jQuery(document).ready(function ($) {
    const pluginMap = {
        yoast: 'wordpress-seo/wp-seo.php',
        rankmath: 'seo-by-rank-math/rank-math.php',
        aioseo: 'all-in-one-seo-pack/all_in_one_seo_pack.php',
        seopress: 'wp-seopress/seopress.php'
    };

    $('#seo_plugin').on('change', function () {
        const selected = $(this).val();
        const messageBox = $('#gsseo-message');
        const pluginKey = pluginMap[selected];
if (selected && gsseo_ajax.active_plugins[selected]) {
    messageBox.html('<p style="color: green;">✅ Plugin is installed and active.</p>');
    $('.upload-section').slideDown();
    $('#upload-btn').prop('disabled', false);
} else {
    messageBox.html('<p style="color: red;">❌ Selected SEO plugin is not installed or active.</p>');
    $('.upload-section').slideUp();
    $('#upload-btn').prop('disabled', true);
}
    });

    $('#gsseo-bulk-form').on('submit', function (e) {
        e.preventDefault();

        const fileInput = $('input[name="csv_file"]')[0];
        const plugin = $('#seo_plugin').val();

        if (!fileInput.files.length) {
            alert('Please select a CSV file.');
            return;
        }

        $('#upload-btn').val('Loading...').prop('disabled', true);

        const reader = new FileReader();
        reader.onload = function (event) {
            const csv = event.target.result.split('\n').slice(1);
            const rows = csv.map(row => row.split(',')).filter(r => r.length >= 3);

            const total = rows.length;
            let processed = 0;

            function processNextChunk(chunkSize = 5) {
                const chunk = rows.splice(0, chunkSize);
                if (chunk.length === 0) {
                    $('#gsseo-finished-message').html('<p style="color: green; margin-top: 10px;">✅ All metadata updated successfully.</p>');
                    setTimeout(() => location.reload(), 2000);
                    return;
                }

                $.post(gsseo_ajax.ajax_url, {
                    action: 'gsseo_process_csv',
                    nonce: gsseo_ajax.nonce,
                    plugin: plugin,
                    rows: chunk
                }, function (response) {
                    if (response.success) {
                        processed += chunk.length;
                        const percent = Math.round((processed / total) * 100);
                        $('#gsseo-progress-wrapper').show();
                        $('#gsseo-progress-count').text(processed);
                        $('#gsseo-progress-fill').css('width', percent + '%').text(percent + '%');

                        processNextChunk();
                    } else {
                        $('#gsseo-finished-message').html('<p style="color: red;">❌ Error updating some entries.</p>');
                        setTimeout(() => location.reload(), 2000);
                    }
                });
            }

            processNextChunk();
        };

        reader.readAsText(fileInput.files[0]);
    });
});
