<?php

namespace GS_BOOKS;

defined('ABSPATH') || exit;

$gsbks_st_isbn_13 = Helpers::get_post_meta('_gsbks_isbn_thirteen');
$is_visible = isset($field) ? Helpers::is_visible($field) : true;
$classes = isset($field) ? Helpers::get_visible_classes($field, 'gsb-info-single') : ['gsb-info-single'];

if (! empty($gsbks_st_isbn_13) && $is_visible) : ?>

    <div class="gsb-isbn-thirteen <?php echo esc_attr(implode(' ', $classes)); ?>">

        <div class="gsb-info-single-name">
            <span class="gsb-info-single-icon"> <i class="fas fa-book-open"></i> </span>
            <?php echo esc_html(Helpers::get_translation('gsb_isbn13_text_modify')); ?>:
        </div>

        <div class="gsb-info-single-value gsb-isbn-thirteen">
            <?php echo esc_html($gsbks_st_isbn_13); ?>
        </div>

    </div>

<?php endif; ?>