<?php

namespace GS_BOOKS;

defined('ABSPATH') || exit;

$gsbks_st_isbn = Helpers::get_post_meta('_gsbks_isbn_ten');
$is_visible = isset($field) ? Helpers::is_visible($field) : true;
$classes = isset($field) ? Helpers::get_visible_classes($field, 'gsb-info-single') : ['gsb-info-single'];

if (! empty($gsbks_st_isbn) && $is_visible) : ?>

    <div class="gsb-isbn-ten <?php echo esc_attr(implode(' ', $classes)); ?>">

        <div class="gsb-info-single-name">
            <span class="gsb-info-single-icon"> <i class="fas fa-barcode"></i> </span>
            <?php echo esc_html(Helpers::get_translation('gsb_isbn_text_modify')); ?>:
        </div>

        <div class="gsb-info-single-value gsb-isbn-ten">
            <?php echo esc_html($gsbks_st_isbn); ?>
        </div>

    </div>

<?php endif; ?>