<?php

namespace GS_BOOKS;

defined('ABSPATH') || exit;

$gsbks_st_fsize = Helpers::get_post_meta('_gsbks_fsize');
$is_visible = isset($field) ? Helpers::is_visible($field) : true;
$classes = isset($field) ? Helpers::get_visible_classes($field, 'gsb-info-single') : ['gsb-info-single'];

if (! empty($gsbks_st_fsize) && $is_visible) : ?>

	<div class="gsb-field <?php echo esc_attr(implode(' ', $classes)); ?>">

		<div class="gsb-info-single-name">
			<span class="gsb-info-single-icon"> <i class="fas fa-file-archive"></i> </span>
			<?php echo esc_html(Helpers::get_translation('gsb_filesize_text_modify')); ?>:
		</div>

		<div class="gsb-info-single-value">
			<?php echo esc_html($gsbks_st_fsize); ?>
		</div>

	</div>

<?php endif; ?>