<?php

namespace GS_BOOKS;

defined('ABSPATH') || exit;

$gsbks_st_url = Helpers::get_post_meta('_gsbks_url');
$is_visible = isset($field) ? Helpers::is_visible($field) : true;
$classes = isset($field) ? Helpers::get_visible_classes($field, 'gsb-info-single') : ['gsb-info-single'];

if (! empty($gsbks_st_url) && $is_visible) : ?>

	<div class="gsb-download-url <?php echo esc_attr(implode(' ', $classes)); ?>">

		<div class="gsb-info-single-name">
			<span class="gsb-info-single-icon"> <i class="fas fa-download"></i> </span>
			<?php echo esc_html(Helpers::get_translation('gsb_download_url_text_modify')); ?>:
		</div>

		<div class="gsb-info-single-value">
			<?php printf(
				'<a href="%s" target="_blank" class="gsb-download-link" rel="noopener noreferrer">%s</a>',
				esc_url($gsbks_st_url),
				esc_html(Helpers::get_translation('gsb_download_text_modify'))
			); ?>
		</div>

	</div>

<?php endif; ?>