<?php

namespace GS_BOOKS;

use function GS_BOOKS_PRO\is_pro_valid;

defined( 'ABSPATH' ) || exit;

?>
<!-- Book Cover & Info -->
<div class="gs-roow">
    <div class="gs-col-md-12">
        <div class="gsb-sp-top-content">
            <?php if ( is_pro_active() && is_pro_valid() && !empty( $gallery_images ) ): ?>
                <div class="gsp-thumb-slider">
                    <div class="swiper mySwiper2">
                        <?php include TemplateLoader::locate_template( 'singles/partials/book-gallery.php' ); ?>
                    </div>
                    <div class="swiper mySwiper">
                        <?php include TemplateLoader::locate_template( 'singles/partials/book-gallery.php' ); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="gsb-sp-cover-img">
                    <div class="gsb-cover-wrapper">
                        <!-- Book Thumbnail -->
                        <?php include TemplateLoader::locate_template( 'singles/partials/post-thumbnails.php' ); ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="gsb-sp-info-details">
                <div class="gsb-sp-info-details-top gsb--scrollbar">

                    <?php

                    $fields = plugin()->builder->get_scoped_fields(['book_name', 'book_author_by', 'book_short_description']);
                    
                    foreach ( $fields as $field_name => $field ) :

                        if ( 'book_name' === $field_name ) : ?>
                            <div class="<?php Helpers::print_visible_classes($field, 'gsb-title'); ?>">
                                <h3><?php the_title(); ?></h3>
                            </div>
                        <?php continue; endif;

                        if ( 'book_author_by' === $field_name ) : ?>
                            <!-- Book Author -->
                            <?php include TemplateLoader::locate_template( 'singles/partials/book-authors.php' ); ?>
                        <?php continue; endif;

                        if ( 'book_short_description' === $field_name && is_pro_active() && is_pro_valid() ) : ?>
                            <!-- Book Short Description -->
                            <?php if ( is_pro_active() && is_pro_valid() ) : ?>
                                <?php include TemplateLoader::locate_template( 'singles/partials/book-short-description.php' ); ?>
                            <?php endif; ?>
                        <?php continue; endif; ?>

                    <?php endforeach; ?>

                    <div class="gsb-book-info">

                        <?php
                        
                        $fields = plugin()->builder->get_scoped_fields(['book_publish_date', 'book_co_publisher', 'book_translator', 'book_categories', 'book_tags', 'book_author', 'book_genres', 'book_series', 'book_languages', 'book_publisher', 'book_countries', 'book_isbn', 'book_isbn_thirteen', 'book_asin', 'book_doi', 'book_llcn', 'book_pages', 'book_dimension', 'book_weight', 'book_file_size', 'book_download_url', 'book_rating', 'book_cover', 'book_regular_price', 'book_sale_price', 'book_availability', 'book_preorder_available', 'book_age_group', 'book_reading_level', 'book_edition', 'book_edition_features', 'book_awards', 'book_reading_time', 'book_accessibility_features']);

                        foreach ( $fields as $field_name => $field ) :

                            // Publish Date
                            if ( $field_name === 'book_publish_date' ) :
                                include TemplateLoader::locate_template( 'singles/partials/published-date.php' );
                            continue; endif;
                        
                            // ISBN 10
                            if ( $field_name === 'book_isbn' ) :
                                include TemplateLoader::locate_template( 'singles/partials/book-isbn-ten.php' );
                            continue; endif;

                            // ISBN 13
                            if ( $field_name === 'book_isbn_thirteen' ) :
                                include TemplateLoader::locate_template( 'singles/partials/book-isbn-thirteen.php' );
                            continue; endif;

                            // Pages
                            if ( $field_name === 'book_pages' ) :
                                include TemplateLoader::locate_template( 'singles/partials/book-pages.php' );
                            continue; endif;

                            // Dimension
                            if ( $field_name === 'book_dimension' ) :
                                include TemplateLoader::locate_template( 'singles/partials/book-dimension.php' );
                            continue; endif;

                            // File Size
                            if ( $field_name === 'book_file_size' ) :
                                include TemplateLoader::locate_template( 'singles/partials/book-file.php' );
                            continue; endif;

                            // Download Url
                            if ( $field_name === 'book_download_url' ) :
                                include TemplateLoader::locate_template( 'singles/partials/book-download-url.php' );
                            continue; endif;

                            // Book Categories
                            if ( $field_name === 'book_categories' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_categories_text_modify') ),
                                    'taxonomy' => 'bookshowcase_group',
                                ]);
                            continue; endif;

                            // Book Tags
                            if ( $field_name === 'book_tags' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_tags_text_modify') ),
                                    'taxonomy' => 'gsb_tag',
                                ]);
                            continue; endif;

                            // Book Authors
                            if ( $field_name === 'book_author' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_authors_text_modify') ),
                                    'taxonomy' => 'gsb_author',
                                ]);
                            continue; endif;

                            // Book Genre
                            if ( $field_name === 'book_genres' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_genres_text_modify') ),
                                    'taxonomy' => 'gsb_genre',
                                ]);
                            continue; endif;

                            // Book Series
                            if ( $field_name === 'book_series' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_series_text_modify') ),
                                    'taxonomy' => 'gsb_series',
                                ]);
                            continue; endif;

                            // Book Language
                            if ( $field_name === 'book_languages' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_languages_text_modify') ),
                                    'taxonomy' => 'gsb_languages',
                                ]);
                            continue; endif;

                            // Book Publisher
                            if ( $field_name === 'book_publisher' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_publishers_text_modify') ),
                                    'taxonomy' => 'gsb_publishers',
                                ]);
                            continue; endif;

                            // Book Countries
                            if ( $field_name === 'book_countries' ) :
                                TemplateLoader::load_template( 'singles/partials/book-taxonomies.php', [
                                    'title'    => esc_html( Helpers::get_translation('gsb_countries_text_modify') ),
                                    'taxonomy' => 'gsb_countries',
                                ]);
                            continue; endif;
                            
                            if ( is_pro_active() && is_pro_valid() ) :
                                
                                // Co-Publisher
                                if ( $field_name === 'book_co_publisher' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-co-publisher.php' );
                                continue; endif;

                                // Book Translator
                                if ( $field_name === 'book_translator' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-translator.php' );
                                continue; endif;
                            
                                // ASIN
                                if ( $field_name === 'book_asin' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-asin.php' );
                                continue; endif;

                                // DOI
                                if ( $field_name === 'book_doi' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-doi.php' );
                                continue; endif;

                                // LLCN
                                if ( $field_name === 'book_llcn' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-llcn.php' );
                                continue; endif;

                                // Weight
                                if ( $field_name === 'book_weight' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-weight.php' );
                                continue; endif;

                                // Rating
                                if ( $field_name === 'book_rating' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-rating.php' );
                                continue; endif;

                                // Cover Variation
                                if ( $field_name === 'book_cover' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-cover-variation.php' );
                                continue; endif;

                                // Regular Price
                                if ( $field_name === 'book_regular_price' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-regular-price.php' );
                                continue; endif;

                                // Sale Price
                                if ( $field_name === 'book_sale_price' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-sale-price.php' );
                                continue; endif;

                                // Book Availability
                                if ( $field_name === 'book_availability' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-availability.php' );
                                continue; endif;

                                // Pre Order Availability
                                if ( $field_name === 'book_preorder_available' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-pre-order.php' );
                                continue; endif;

                                // Age Group
                                if ( $field_name === 'book_age_group' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-age-group.php' );
                                continue; endif;

                                // Reading Level
                                if ( $field_name === 'book_reading_level' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-reading-level.php' );
                                continue; endif;

                                // Book Edition
                                if ( $field_name === 'book_edition' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-edition.php' );
                                continue; endif;

                                // Book Edition Features
                                if ( $field_name === 'book_edition_features' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-edition-features.php' );
                                continue; endif;

                                // Awards
                                if ( $field_name === 'book_awards' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-awards.php' );
                                continue; endif;

                                // Reading Time
                                if ( $field_name === 'book_reading_time' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-reading-time.php' );
                                continue; endif;

                                // Accessibility Features
                                if ( $field_name === 'book_accessibility_features' ) :
                                    include TemplateLoader::locate_template( 'singles/partials/book-accessibility-features.php' );
                                continue; endif;

                            endif;

                        endforeach;

                        ?>

                    </div>

                </div>

                <?php

                $fields = plugin()->builder->get_scoped_fields(['book_store']);

                foreach ( $fields as $field_name => $field ) :

                    if ( is_pro_active() && is_pro_valid() ) :

                        // Book Retails
                        if ( !empty( Helpers::has_post_meta('gs_repeatable_fields')) && Helpers::is_visible($field) ) : ?>
                            <div class="<?php Helpers::print_visible_classes($field, 'gsb-sp-info-details-bottom'); ?>">
                                <div class="gsb-book-info">
                                    <?php include TemplateLoader::locate_template( 'singles/partials/book-retails.php' ); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                    <?php endif; ?>

                <?php endforeach; ?>

            </div>
        </div>
    </div>
</div>

<?php

$fields = plugin()->builder->get_scoped_fields(['book_formats', 'book_details', 'readers_review', 'book_author_section', 'book_related_section']);

foreach ( $fields as $field_name => $field ) :

    // Book Description
    if ( $field_name === 'book_details' && !empty( trim( get_the_content() ) ) ) : ?>
        <div class="<?php Helpers::print_visible_classes($field, 'gs-roow'); ?>">
            <div class="gs-col-md-12">
                <div class="gsb-sp-section-space">
                    <!-- Description Section -->
                    <?php include TemplateLoader::locate_template( 'singles/partials/book-description.php' ); ?>
                </div>
            </div>
        </div>
    <?php continue; endif;

    // Related Books
    if ( $field_name === 'book_related_section' && Helpers::get_related_books_query()->have_posts() ) : ?>
        <div class="<?php Helpers::print_visible_classes($field, 'gs-roow gsb-sp-section-space gsb-sp-section-style'); ?>">
            <div class="gs-col-md-12">
                <!-- Related Books Title -->
                <div class="gsb-sp-label">
                    <h3><?php echo esc_html( Helpers::get_translation('gsb_sim_cat_books_text_modify') ); ?></h3>
                </div>
                <!-- Related Books -->
                <?php require TemplateLoader::locate_template( 'partials/gs-related-books.php' ); ?>
            </div>
        </div>
    <?php continue; endif;

    if ( is_pro_active() && is_pro_valid() ) :

        // Book Formats
        if ( $field_name === 'book_formats' && !empty( Helpers::has_post_meta( 'gs_repeatable_formats' ) ) ) : ?>
            <div class="<?php Helpers::print_visible_classes($field, 'gs-roow'); ?>">
                <div class="gs-col-md-12">
                    <div class="gsb-book-formate gsb-sp-section-space">
                        <?php include TemplateLoader::locate_template( 'singles/partials/book-formats.php' ); ?>
                    </div>
                </div>
            </div>
        <?php continue; endif;

        // Reader Review
        if ( $field_name === 'readers_review' && !empty( Helpers::get_post_meta('_gsbks_review') ) ) : ?>
            <div class="<?php Helpers::print_visible_classes($field, 'gs-roow'); ?>">
                <div class="gs-col-md-12">
                    <div class="gs-book-review gsb-sp-section-space">
                        <div class="gsb-sp-label">
                            <h3><?php echo esc_html( Helpers::get_translation('gsb_readers_text_modify') ); ?>:</h3>
                        </div>
                        <?php include TemplateLoader::locate_template('singles/partials/book-review.php'); ?>
                    </div>
                </div>
            </div>
        <?php continue; endif;

        // Author Details
        if ( $field_name === 'book_author_section' && Helpers::has_author_info() ) : ?>
            <div class="<?php Helpers::print_visible_classes($field, 'gs-roow'); ?>">
                <div class="gs-col-md-12">
                    <div class="gsb-author-details gsb-sp-section-space">
                        <?php require TemplateLoader::locate_template( 'partials/gs-author-details.php' ); ?>
                    </div>
                </div>
            </div>
        <?php continue; endif;

    endif;

endforeach;

if ( is_pro_active() && is_pro_valid() ) :
    echo do_shortcode('[gs_ajax_login]');
endif; ?>