<?php

namespace GS_BOOKS;

use function GS_BOOKS_PRO\is_pro_valid;

defined('ABSPATH') || exit;

?>

<div class="gs-containeer-f" itemscope="" itemtype="http://schema.org/Person">

    <!-- Book Cover & Info -->
    <div class="gs-roow">

        <div class="gs-col-md-12">

            <div class="gsb-sp-top-content gsb-sp-spacing-border">

                <div class="gsb-sp-cover-img">

                    <div class="gsb-cover-wrapper">

                        <!-- Book Thumbnail -->
                        <?php include TemplateLoader::locate_template('singles/partials/post-thumbnails.php'); ?>

                    </div>

                </div>

                <div class="gsb-sp-info-details">

                    <div class="gsb-sp-info-details-top gsb--scrollbar">

                        <!-- Book Title -->
                        <?php if (Helpers::is_visible($detail_visibility_settings['book_name'])) : ?>
                            <div class="<?php Helpers::print_visible_classes($detail_visibility_settings['book_name'], 'gsb-title'); ?>">
                                <h3><?php the_title(); ?></h3>
                            </div>
                        <?php endif; ?>

                        <?php if (is_pro_active() && is_pro_valid()): ?>

                            <!-- Book Author -->
                            <?php TemplateLoader::load_template('singles/partials/book-authors.php', ['field' => $detail_visibility_settings['book_author_by']]); ?>

                            <!-- Book Short Description -->
                            <?php TemplateLoader::load_template('singles/partials/book-short-description.php', ['field' => $detail_visibility_settings['book_short_description']]); ?>

                        <?php endif; ?>

                        <div class="gsb-book-info">

                            <!-- Publish Date -->
                            <?php TemplateLoader::load_template('singles/partials/published-date.php', ['field' => $detail_visibility_settings['book_publish_date']]); ?>

                            <?php if (is_pro_active() && is_pro_valid()): ?>

                                <!-- Co-Publisher -->
                                <?php TemplateLoader::load_template('singles/partials/book-co-publisher.php', ['field' => $detail_visibility_settings['book_co_publisher']]); ?>

                                <!-- Translator -->
                                <?php TemplateLoader::load_template('singles/partials/book-translator.php', ['field' => $detail_visibility_settings['book_translator']]); ?>
                               
                            <?php endif; ?>

                            <!-- Book Categories -->
                            <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                'field'    => $detail_visibility_settings['book_categories'],
                                'title'    => esc_html(Helpers::get_translation('gsb_categories_text_modify')),
                                'taxonomy' => 'bookshowcase_group',
                            ]); ?>

                            <!-- Book Tags -->
                            <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                'field'    => $detail_visibility_settings['book_tags'],
                                'title'    => esc_html(Helpers::get_translation('gsb_tags_text_modify')),
                                'taxonomy' => 'gsb_tag',
                            ]); ?>

                            <?php if (is_pro_active() && is_pro_valid()): ?>

                                <!-- Book Authors -->
                                <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                    'field'    => $detail_visibility_settings['book_author'],
                                    'title'    => esc_html(Helpers::get_translation('gsb_authors_text_modify')),
                                    'taxonomy' => 'gsb_author',
                                ]); ?>

                                <!-- Book Genre -->
                                <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                    'field'    => $detail_visibility_settings['book_genres'],
                                    'title'    => esc_html(Helpers::get_translation('gsb_genres_text_modify')),
                                    'taxonomy' => 'gsb_genre',
                                ]); ?>

                                <!-- Book Series -->
                                <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                    'field'    => $detail_visibility_settings['book_series'],
                                    'title'    => esc_html(Helpers::get_translation('gsb_series_text_modify')),
                                    'taxonomy' => 'gsb_series',
                                ]); ?>

                                <!-- Book Language -->
                                <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                    'field'    => $detail_visibility_settings['book_languages'],
                                    'title'    => esc_html(Helpers::get_translation('gsb_languages_text_modify')),
                                    'taxonomy' => 'gsb_languages',
                                ]); ?>

                                <!-- Book Publisher -->
                                <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                    'field'     => $detail_visibility_settings['book_publisher'],
                                    'title'     => esc_html(Helpers::get_translation('gsb_publishers_text_modify')),
                                    'taxonomy'  => 'gsb_publishers',
                                ]); ?>

                                <!-- Book Countries -->
                                <?php TemplateLoader::load_template('singles/partials/book-taxonomies.php', [
                                    'field'    => $detail_visibility_settings['book_countries'],
                                    'title'    => esc_html(Helpers::get_translation('gsb_countries_text_modify')),
                                    'taxonomy' => 'gsb_countries',
                                ]); ?>
                            <?php endif; ?>

                            <!-- ISBN 10 -->
                            <?php TemplateLoader::load_template('singles/partials/book-isbn-ten.php', ['field' => $detail_visibility_settings['book_isbn']]); ?>

                            <!-- ISBN 13 -->
                            <?php TemplateLoader::load_template('singles/partials/book-isbn-thirteen.php', ['field' => $detail_visibility_settings['book_isbn_thirteen']]); ?>

                            <?php if (is_pro_active() && is_pro_valid()): ?>
                                <!-- ASIN -->
                                <?php TemplateLoader::load_template('singles/partials/book-asin.php', ['field' => $detail_visibility_settings['book_asin']]); ?>

                                <!-- DOI -->
                                <?php TemplateLoader::load_template('singles/partials/book-doi.php', ['field' => $detail_visibility_settings['book_doi']]); ?>

                                <!-- LLCN -->
                                <?php TemplateLoader::load_template('singles/partials/book-llcn.php', ['field' => $detail_visibility_settings['book_llcn']]); ?>

                                <!-- Pages -->
                                <?php TemplateLoader::load_template('singles/partials/book-pages.php', ['field' => $detail_visibility_settings['book_pages']]); ?>

                            <?php endif; ?>

                            <!-- Dimension -->
                            <?php TemplateLoader::load_template('singles/partials/book-dimension.php', ['field' => $detail_visibility_settings['book_dimension']]); ?>

                            <?php if (is_pro_active() && is_pro_valid()): ?>
                                <!-- Weight -->
                                <?php TemplateLoader::load_template('singles/partials/book-weight.php', ['field' => $detail_visibility_settings['book_weight']]); ?>
                            <?php endif; ?>

                            <!-- File Size -->
                            <?php TemplateLoader::load_template('singles/partials/book-file.php', ['field' => $detail_visibility_settings['book_file_size']]); ?>

                            <!-- Download Url -->
                            <?php TemplateLoader::load_template('singles/partials/book-download-url.php', ['field' => $detail_visibility_settings['book_download_url']]); ?>

                            <?php if (is_pro_active() && is_pro_valid()): ?>

                                <!-- Rating -->
                                <?php TemplateLoader::load_template('singles/partials/book-rating.php', ['field' => $detail_visibility_settings['book_rating']]); ?>

                                <!-- Cover Variation -->
                                <?php TemplateLoader::load_template('singles/partials/book-cover-variation.php', ['field' => $detail_visibility_settings['book_cover']]); ?>

                                <!-- Regular Price -->
                                <?php TemplateLoader::load_template('singles/partials/book-regular-price.php', ['field' => $detail_visibility_settings['book_regular_price']]); ?>

                                <!-- Sale Price -->
                                <?php TemplateLoader::load_template('singles/partials/book-sale-price.php', ['field' => $detail_visibility_settings['book_sale_price']]); ?>

                                <!-- Book Availability -->
                                <?php TemplateLoader::load_template('singles/partials/book-availability.php', ['field' => $detail_visibility_settings['book_availability']]); ?>

                                <!-- Pre Order Availability -->
                                <?php TemplateLoader::load_template('singles/partials/book-pre-order.php', ['field' => $detail_visibility_settings['book_preorder_available']]); ?>

                                <!-- Age Group -->
                                <?php TemplateLoader::load_template('singles/partials/book-age-group.php', ['field' => $detail_visibility_settings['book_age_group']]); ?>

                                <!-- Reading Level -->
                                <?php TemplateLoader::load_template('singles/partials/book-reading-level.php', ['field' => $detail_visibility_settings['book_reading_level']]); ?>

                                <!-- Book Edition -->
                                <?php TemplateLoader::load_template('singles/partials/book-edition.php', ['field' => $detail_visibility_settings['book_edition']]); ?>

                                <!-- Book Edition Features -->
                                <?php TemplateLoader::load_template('singles/partials/book-edition-features.php', ['field' => $detail_visibility_settings['book_edition_features']]); ?>

                                <!-- Awards -->
                                <?php TemplateLoader::load_template('singles/partials/book-awards.php', ['field' => $detail_visibility_settings['book_awards']]); ?>

                                <!-- Reading Time -->
                                <?php TemplateLoader::load_template('singles/partials/book-reading-time.php', ['field' => $detail_visibility_settings['book_reading_time']]); ?>

                                <!-- Accessibility Features -->
                                <?php TemplateLoader::load_template('singles/partials/book-accessibility-features.php', ['field' => $detail_visibility_settings['book_accessibility_features']]); ?>

                            <?php endif; ?>

                        </div>

                    </div>

                    <?php if (is_pro_active() && is_pro_valid() && !empty(Helpers::has_post_meta('gs_repeatable_fields')) && Helpers::is_visible($detail_visibility_settings['book_store'])) : ?>

                        <!-- Book Retails -->
                        <div class="<?php Helpers::print_visible_classes($detail_visibility_settings['book_store'], 'gsb-sp-info-details-bottom'); ?>">
                            <div class="gsb-book-info">
                                <?php TemplateLoader::load_template('singles/partials/book-retails.php'); ?>
                            </div>
                        </div>

                    <?php endif; ?>

                </div>

            </div>

        </div>

    </div>

    <?php if (is_pro_active() && is_pro_valid() && !empty(Helpers::has_post_meta('gs_repeatable_formats')) && Helpers::is_visible($detail_visibility_settings['book_formats'])) : ?>
        <!-- Book formats -->
        <div class="<?php Helpers::print_visible_classes($detail_visibility_settings['book_formats'], 'gs-roow'); ?>">
            <div class="gs-col-md-12">
                <div class="gsb-book-formate gsb-sp-section-space">
                    <!-- Book Formats -->
                    <?php include TemplateLoader::locate_template('singles/partials/book-formats.php'); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (! empty(trim(get_the_content())) && Helpers::is_visible($detail_visibility_settings['book_details'])) : ?>
        <!-- Description Section -->
        <div class="<?php Helpers::print_visible_classes($detail_visibility_settings['book_details'], 'gs-roow'); ?>">
            <div class="gs-col-md-12">
                <div class="gsb-sp-section-space gsb-sp-spacing-border">
                    <?php include TemplateLoader::locate_template('singles/partials/book-description.php'); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (is_pro_active() && is_pro_valid() && ! empty(Helpers::get_post_meta('_gsbks_review')) && Helpers::is_visible($detail_visibility_settings['readers_review'])) : ?>
        <!-- Reader Review -->
        <div class="<?php Helpers::print_visible_classes($detail_visibility_settings['readers_review'], 'gs-roow'); ?>">
            <div class="gs-col-md-12">
                <div class="gs-book-review gsb-sp-section-space">
                    <div class="gsb-sp-label">
                        <h3><?php echo esc_html(Helpers::get_translation('gsb_readers_text_modify')); ?>:</h3>
                    </div>
                    <?php include TemplateLoader::locate_template('singles/partials/book-review.php'); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (is_pro_active() && is_pro_valid() && Helpers::has_author_info() && Helpers::is_visible($detail_visibility_settings['book_author_section'])) : ?>
        <!-- Author Details -->
        <div class="<?php Helpers::print_visible_classes($detail_visibility_settings['book_author_section'], 'gs-roow'); ?>">
            <div class="gs-col-md-12">
                <div class="gsb-author-details gsb-sp-section-space">
                    <?php require TemplateLoader::locate_template('partials/gs-author-details.php'); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>