<?php

namespace GS_BOOKS;

use function GS_BOOKS_PRO\is_pro_valid;

defined( 'ABSPATH' ) || exit;

if ( ! $_popup_enabled ) return;

if ( ! is_pro_active() || ! is_pro_valid() ) $popup_style = 'style_one';

?>

<div id="gs_book_popup_<?php echo esc_attr( get_the_id() ); ?>" class="gs_book_popup_shortcode_<?php echo esc_attr( $id ); ?> white-popup mfp-hide mfp-with-anim gs_book_popup">
	<div class="mfp-content--container">
		<?php

		if ( is_pro_active() && is_pro_valid() ) {
			$author_img_field = $detail_visibility_settings['book_author_img'];
			$author_social_field = $detail_visibility_settings['book_author_social'];
		}

		switch ( $popup_style ) {

			case 'style_one':
				include TemplateLoader::locate_template( 'popups/gsb-popup-style-01.php' );
				break;

			case 'style_two':
				include TemplateLoader::locate_template( 'popups/gsb-popup-style-02.php' );
				break;

			case 'style_three':
				include TemplateLoader::locate_template( 'popups/gsb-popup-style-03.php' );
				break;

			case 'style_four':
				include TemplateLoader::locate_template( 'popups/gsb-popup-style-04.php' );
				break;

			case 'style_five':
				include TemplateLoader::locate_template( 'popups/gsb-popup-style-05.php' );
				break;

			default:
				include TemplateLoader::locate_template( 'popups/gsb-popup-style-01.php' );
		}
		?>
	</div>
</div>