<?php

namespace GS_BOOKS;

defined( 'ABSPATH' ) || exit;

if ( empty( $term->term_id ) ) {
    $term = $author_term[0];
}

if ( empty( $term->term_id ) ) return;

$author_socials = get_term_meta( $term->term_id, 'author-taxonomy-repeat', true );

$author_social_is_visible = isset($author_social_field) ? Helpers::is_visible($author_social_field) : true;
$author_social_classes = isset($author_social_field) ? Helpers::get_visible_classes($author_social_field, 'gsb-author-social') : ['gsb-author-social'];

if ( is_array( $author_socials ) && ! empty( $author_socials ) && $author_social_is_visible ) : ?>
    <ul class="<?php echo esc_attr( implode( ' ', $author_social_classes ) ); ?>">
        <?php foreach( $author_socials as $author_social ): ?>
            <li>
                <a href="<?php echo esc_url( $author_social['url'] ); ?>" target="_blank">
                    <i class="<?php echo esc_attr( $author_social['icon'] ); ?>"></i>
                </a>
            </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>