<?php

namespace GS_BOOKS;

use GS_BOOKS_PRO\Helpers as Pro_Helpers;

use function GS_BOOKS_PRO\is_pro_valid;

defined('ABSPATH') || exit;

if ($query->have_posts()) :

	while ($query->have_posts()) :

		$query->the_post();
		$authors            = Helpers::post_authors(true);
		$publish            = Helpers::get_post_meta('_gsbks_publish');
		$publisher          = Helpers::book_publisher();
		$gsbks_st_isbn      = Helpers::get_post_meta('_gsbks_isbn_ten');
		$gsbks_st_isbn_13   = Helpers::get_post_meta('_gsbks_isbn_thirteen');
		$gsbks_st_asin      = Helpers::get_post_meta('_gsbks_asin');
		$url                = Helpers::get_post_meta('_gsbks_url');
		$classes            = (array) Helpers::get_col_classes($columns, $columns_tablet, $columns_mobile_portrait, $columns_mobile);

		if (is_pro_active() && is_pro_valid()) {

			$gs_book_rating = Helpers::get_post_meta('_gsbks_rating');
			$all_terms = Helpers::get_all_terms(get_the_ID());
			if ($view_type === 'filter') {
				$classes[] = 'gs-term-single-item';
				$classes[] = $all_terms;
			}
		}

?>

		<div class="horizontal-single <?php echo esc_attr(implode(' ', $classes)); ?>">

			<div class="single-bookshowcase">

				<!-- Post Image / Thumbnail -->
				<div class="gsb-cover-wrapper">
					<?php Helpers::gs_book_thumbnail_with_link($gs_book_thumbnail_sizes, esc_html($link_type), '', esc_html($popup_style)); ?>
				</div>

				<div class="gsb-book-info-wrapper">

					<?php
					if (Helpers::is_visible($visibility_settings['book_name'])) : ?>
						<div class="<?php Helpers::print_visible_classes($visibility_settings['book_name'], 'gsb-title'); ?>">
							<h3><?php Helpers::post_title($link_type, $popup_style); ?></h3>
						</div>
					<?php endif;

					if (! empty($authors) && Helpers::is_visible($visibility_settings['book_author_by'])) : ?>
						<div class="<?php Helpers::print_visible_classes($visibility_settings['book_author_by'], 'gsb-author'); ?>">
							<h4><?php echo esc_html(Helpers::get_translation('gsb_by_text_modify')); ?> <?php Helpers::wp_kses($authors); ?></h4>
						</div>
					<?php endif; ?>

					<!-- bookshowcase Excerpt -->
					<?php if (Helpers::is_visible($visibility_settings['book_details'])) : ?>
						<div class="<?php Helpers::print_visible_classes($visibility_settings['book_details'], 'gsb-desc'); ?>">
							<p><?php Helpers::post_content($desc_limit, true, true, $link_type, $popup_style); ?></p>
						</div>
					<?php endif; ?>

					<!-- bookshowcase Excerpt -->
					<div class="gsb-book-info">

						<?php if (!empty($publish) && Helpers::is_visible($visibility_settings['book_publish_date'])) : ?>
							<p class="<?php Helpers::print_visible_classes($visibility_settings['book_publish_date']); ?>">
								<span><?php echo esc_html(Helpers::get_translation('gsb_publish_text_modify')); ?>: </span> <?php echo esc_html($publish); ?>
							</p>
							<?php endif;

						if (is_pro_active() && is_pro_valid()) :

							if (!empty($publisher) && Helpers::is_visible($visibility_settings['book_publisher'])) : ?>
								<p class="<?php Helpers::print_visible_classes($visibility_settings['book_publisher']); ?>">
									<span><?php echo esc_html(Helpers::get_translation('gsb_publishers_text_modify')); ?>: </span> <?php Helpers::wp_kses($publisher); ?>
								</p>
							<?php endif;

							if (! empty($gs_book_rating) && Helpers::is_visible($visibility_settings['book_rating'])) : ?>
								<p class="<?php Helpers::print_visible_classes($visibility_settings['book_rating'], 'rating'); ?>">
									<span class="gsb-info-lavel"><?php echo esc_html(Helpers::get_translation('gsb_rating_text_modify')); ?>: </span>
									<span class="gsb-info-value"><?php Pro_Helpers::get_rating(); ?></span>
								</p>
							<?php endif;

							$store_links = Helpers::get_store_links();

							if (! empty($store_links) && Helpers::is_visible($visibility_settings['book_store'])) : ?>
								<p class="<?php Helpers::print_visible_classes($visibility_settings['book_store']); ?>">
									<span class="gsb-info-lavel"><?php echo esc_html(Helpers::get_translation('gsb_store_text_modify')); ?>: </span>
									<span class="gsb-info-value"><?php Helpers::wp_kses($store_links); ?> </span>
								</p>
						<?php endif;

						endif; ?>

					</div>

				</div>

			</div>
			<?php include TemplateLoader::locate_template('popups/gsb-layout-popup.php'); ?>
		</div>

<?php

	endwhile;

else :

	include TemplateLoader::locate_template('partials/gsb-no-book.php');

endif;

wp_reset_postdata();
