<?php

namespace GS_BOOKS;

defined( 'ABSPATH' ) || exit;

/**
 * Responsible for displaying plugin notices.
 *
 * @since 1.2.11
 */
class Notices {

	/**
	 * Class constructor.
	 *
	 * @since 1.2.11
	 */
	public function __construct() {
		// add_action( 'admin_notices', 'gs_admin_tickr_notice' );
		// add_action( 'admin_init', 'gstickr_nag_ignore' );
		// add_action( 'admin_init', 'gsadmin_signup_notice' );
	}

	public function gs_admin_tickr_notice() {
		global $current_user;
		$user_id = $current_user->ID;

		if ( ! get_user_meta( $user_id, 'gstickr_nag_ignore' ) ) {
			$protocol      = is_ssl() ? 'https' : 'http';
			$promo_content = wp_remote_get( $protocol . '://gsplugins.com/gs_plugins_list/admin_notice.php' );
			?>
			<div class="notice notice-info" style="position: relative;">
			<?php
				echo wp_kses_post($promo_content['body']);
				printf('<a href="%1$s" style="text-decoration: none; background: #fff;right:6px;top: 10px; float:right;position: absolute;"><span class="dashicons dashicons-dismiss"></span></a>', esc_url( admin_url( 'index.php?&gstickr_nag_ignore=0' ) ) );
			?>
			</div>
			<?php
		}
	}

	public function gstickr_nag_ignore() {
		global $current_user;
		$user_id = $current_user->ID;

		/* If user clicks to ignore the notice, add that to their user meta */
		if ( isset( $_GET['gstickr_nag_ignore'] ) && '0' == $_GET['gstickr_nag_ignore'] ) {
			add_user_meta( $user_id, 'gstickr_nag_ignore', 'true', true );
			add_site_option( 'gstickr_active_time', time() );
		}

		$daysinseconds   = 259200; // 3 Days in seconds.
		$activation_time = get_site_option( 'gstickr_active_time' );

		if ( time() - $activation_time > $daysinseconds ) {
			delete_option( 'gstickr_active_time' );
			delete_user_meta( $user_id, 'gstickr_nag_ignore' );
		}
	}

	public function gsadmin_signup_notice() {
		$this->gsadmin_signup_pending();

		$activation_time = get_site_option( 'gsadmin_active_time' );
		$maybe_later     = get_site_option( 'gsadmin_maybe_later' );

		if ( ! $activation_time ) {
			add_site_option( 'gsadmin_active_time', time() );
		}

		if ( 'yes' == $maybe_later ) {
			$daysinseconds = 604800; // 7 Days in seconds.
			if ( time() - $activation_time > $daysinseconds ) {
				add_action( 'admin_notices', array( $this, 'gsadmin_signup_notice_message' ) );
			}
		} else {
			add_action( 'admin_notices', array( $this, 'gsadmin_signup_notice_message' ) );
		}

	}

	/**
	 * For the notice signup.
	 *
	 * @since 1.2.11
	 */
	public function gsadmin_signup_notice_message() {
		$scheme      = ( parse_url( $_SERVER['REQUEST_URI'], PHP_URL_QUERY ) ) ? '&' : '?';
		$_later_link = $_SERVER['REQUEST_URI'] . $scheme . 'gsadmin_signup_later=yes';
		$later_url   = wp_nonce_url( $_later_link, 'gsadmin-signup-nonce' );
		?>
		<div class="gstesti-admin-notice updated gsteam-review-notice">
			<div class="gsteam-review-text">
				<h3><?php echo esc_html__( 'GS Plugins Affiliate Program is now LIVE!', 'gs-books-showcase' ); ?></h3>
				<p><?php echo esc_html__( 'Join GS Plugins affiliate program. Share our 80% OFF lifetime bundle deals or any plugin with your friends/followers and earn up to 50% commission.', 'gs-books-showcase' ); ?> <a href="<?php echo esc_url('https://www.gsplugins.com/affiliate-registration/?utm_source=wporg&utm_medium=admin_notice&utm_campaign=aff_regi') ?>" target="_blank"><?php echo esc_html__( 'Click here to sign up.', 'gs-books-showcase' ); ?></a></p>
				<ul class="gsteam-review-ul">
					<li style="display: inline-block;margin-right: 15px;">
						<a href="<?php echo esc_url($later_url); ?>" style="display: inline-block;color: #10738B;text-decoration: none;position: relative;">
							<span class="dashicons dashicons-dismiss"></span>
							<?php echo esc_html_e( 'Hide Now', 'gs-books-showcase' ); ?>
						</a>
					</li>
				</ul>
			</div>
		</div>
		<?php
	}

	/**
	 * For Maybe Later signup.
	 *
	 * @since 1.2.11
	 */
	function gsadmin_signup_pending() {
		if ( ! is_admin() ||
			! current_user_can( 'manage_options' ) ||
			! isset( $_GET['_wpnonce'] ) ||
			! wp_verify_nonce( sanitize_key( wp_unslash( $_GET['_wpnonce'] ) ), 'gsadmin-signup-nonce' ) ||
			! isset( $_GET['gsadmin_signup_later'] ) ) {

			return;
		}
		// Reset Time to current time.
		update_site_option( 'gsadmin_maybe_later', 'yes' );
	}
}