<?php

namespace GS_BOOKS;

defined( 'ABSPATH' ) || exit;

/**
 * Registers a new post type
 *
 * @since 1.2.11
 */
class CPT {

	public function __construct() {
		add_action( 'init', array( $this, 'register_post_type' ) );
		add_action( 'init', array( $this, 'register_taxonomies' ) );
		add_action( 'after_setup_theme', array( $this, 'theme_supports' ) );
	}

	public function register_taxonomies() {
		$this->gsb_categories();
		$this->gsb_books_tag();
		do_action( 'gsb_after_register_taxonomy' );
	}

	public function gsb_categories() {

		if ( plugin()->builder->get_tax_option( 'enable_group_tax' ) !== 'on' ) {
			return;
		}

		$plural   = plugin()->builder->get_tax_option( 'group_tax_plural_label' );
		$singular = plugin()->builder->get_tax_option( 'group_tax_label' );

		$labels = array(
			'name'          => $plural,
			'singular_name' => $singular,

			/* translators: %s: plural label for the post type. */
			'all_items'     => sprintf( esc_html__( 'All %s', 'gs-books-showcase' ), esc_html( $plural ) ),

			/* translators: %s: singular label for the post type. */
			'parent_item'   => sprintf( esc_html__( 'Parent %s', 'gs-books-showcase' ), esc_html( $singular ) ),

			/* translators: %s: singular label for the post type. */
			'parent_item_colon' => sprintf( esc_html__( 'Parent %s', 'gs-books-showcase' ), esc_html( $singular ) ),

			/* translators: %s: singular label for the post type. */
			'new_item_name' => sprintf( esc_html__( 'New %s', 'gs-books-showcase' ), esc_html( $singular ) ),

			/* translators: %s: singular label for the post type. */
			'add_new_item'  => sprintf( esc_html__( 'Add New %s', 'gs-books-showcase' ), esc_html( $singular ) ),

			/* translators: %s: singular label for the post type. */
			'edit_item'     => sprintf( esc_html__( 'Edit %s', 'gs-books-showcase' ), esc_html( $singular ) ),

			/* translators: %s: singular label for the post type. */
			'update_item'   => sprintf( esc_html__( 'Update %s', 'gs-books-showcase' ), esc_html( $singular ) ),

			/* translators: %s: plural label for the post type. */
			'separate_items_with_commas' => sprintf( esc_html__( 'Separate %s with commas', 'gs-books-showcase' ), esc_html( $plural ) ),

			/* translators: %s: plural label for the post type. */
			'search_items'  => sprintf( esc_html__( 'Search %s', 'gs-books-showcase' ), esc_html( $plural ) ),

			/* translators: %s: plural label for the post type. */
			'add_or_remove_items' => sprintf( esc_html__( 'Add or remove %s', 'gs-books-showcase' ), esc_html( $plural ) ),

			/* translators: %s: plural label for the post type. */
			'choose_from_most_used' => sprintf( esc_html__( 'Choose from the most used %s', 'gs-books-showcase' ), esc_html( $plural ) ),

			'not_found'     => esc_html__( 'Not Found', 'gs-books-showcase' ),
		);

		$rewrite = array(
			'slug'         => plugin()->builder->get_tax_option( 'group_tax_archive_slug', 'bookshowcase_group' ),
			'with_front'   => true,
			'hierarchical' => false,
		);

		$args = array(
			'labels'            => $labels,
			'hierarchical'      => true,
			'public'            => true,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_nav_menus' => false,
			'show_tagcloud'     => false,
			'rewrite'           => $rewrite,
		);

		register_taxonomy( 'bookshowcase_group', array( 'gs_bookshowcase' ), $args );
	}

	public function gsb_books_tag() {

		if ( plugin()->builder->get_tax_option( 'enable_tag_tax' ) !== 'on' ) {
			return;
		}

		$rewrite = array(
			'slug'         => plugin()->builder->get_tax_option( 'tag_tax_archive_slug', 'gsb_tag' ),
			'with_front'   => true,
			'hierarchical' => false,
		);

		$plural   = plugin()->builder->get_tax_option( 'tag_tax_plural_label' );
		$singular = plugin()->builder->get_tax_option( 'tag_tax_label' );

		register_taxonomy(
			'gsb_tag',
			'gs_bookshowcase',
			array(
				'hierarchical'      => true,
				'labels'            => array(
					'name'                       => $plural,
					'singular_name'              => $singular,
					// translators: %s: Plural name of the taxonomy (e.g., Book).
					'all_items'                  => sprintf( esc_html__( 'All %s','gs-books-showcase' ), $plural ),
					// translators: %s: Singular name of the taxonomy (e.g., Book).
					'parent_item'                => sprintf( esc_html__( 'Parent %s','gs-books-showcase' ), $singular ),
					// translators: %s: Singular name of the taxonomy (e.g., Book).
					'parent_item_colon'          => sprintf( esc_html__( 'Parent %s','gs-books-showcase' ), $singular ),
					// translators: %s: Singular name of the taxonomy (e.g., Book).
					'new_item_name'              => sprintf( esc_html__( 'New %s','gs-books-showcase' ), $singular ),
					// translators: %s: Singular name of the taxonomy (e.g., Book).
					'add_new_item'               => sprintf(  esc_html__( 'Add New %s','gs-books-showcase' ), $singular ),
					// translators: %s: Singular name of the taxonomy (e.g., Book).
					'edit_item'                  => sprintf( esc_html__( 'Edit %s','gs-books-showcase' ), $singular ),
					// translators: %s: Singular name of the taxonomy (e.g., Book).
					'update_item'                => sprintf( esc_html__( 'Update %s','gs-books-showcase' ), $singular ),
					// translators: %s: Plural name of the taxonomy (e.g., Book).
					'separate_items_with_commas' => sprintf( esc_html__( 'Separate %s with commas','gs-books-showcase' ), $plural ),
					// translators: %s: Plural name of the taxonomy (e.g., Book).
					'search_items'               => sprintf( esc_html__( 'Search %s','gs-books-showcase' ), $plural ),
					// translators: %s: Plural name of the taxonomy (e.g., Book).
					'add_or_remove_items'        => sprintf( esc_html__( 'Add or remove %s','gs-books-showcase' ), $plural ),
					// translators: %s: Plural name of the taxonomy (e.g., Book).
					'choose_from_most_used'      => sprintf( esc_html__( 'Choose from the most used %s','gs-books-showcase' ), $plural ),
					'not_found'                  => esc_html__( 'Not Found', 'gs-books-showcase' ),
				),
				'show_ui'           => true,
				'show_admin_column' => true,
				'rewrite'           => $rewrite,
			)
		);
	}

	public function register_post_type() {
		$labels = array(
			'name'               	=> is_admin() ? get_post_type_title() : gs_get_post_type_archive_title(),
			'singular_name'         => _x( 'Book', '','gs-books-showcase' ),
			'menu_name'             => _x( 'Book Showcase', 'admin menu', 'gs-books-showcase' ),
			'name_admin_bar'        => _x( 'Book Showcase', 'add new on admin bar', 'gs-books-showcase' ),
			'add_new'               => _x( 'Add New', 'book', 'gs-books-showcase' ),
			'add_new_item'          => esc_html__( 'Add New', 'gs-books-showcase' ),
			'new_item'              => esc_html__( 'New Book', 'gs-books-showcase' ),
			'edit_item'             => esc_html__( 'Edit Book', 'gs-books-showcase' ),
			'view_item'             => esc_html__( 'View Book', 'gs-books-showcase' ),
			'all_items'             => esc_html__( 'Books', 'gs-books-showcase' ),
			'search_items'          => esc_html__( 'Search Books', 'gs-books-showcase' ),
			'parent_item_colon'     => esc_html__( 'Parent Book:', 'gs-books-showcase' ),
			'not_found'             => esc_html__( 'No Book found.', 'gs-books-showcase' ),
			'not_found_in_trash'    => esc_html__( 'No Book found in Trash.', 'gs-books-showcase' ),
			'featured_image'        => esc_html__( 'Book Cover', 'gs-books-showcase' ),
			'set_featured_image'    => esc_html__( 'Set Book Cover', 'gs-books-showcase' ),
			'remove_featured_image' => esc_html__( 'Remove Book Cover', 'gs-books-showcase' ),
		);

		$gs_books_slug = getoption( 'books_slug', 'books' );
		$replace_custom_slug = wp_validate_boolean( getoption( 'replace_custom_slug', false ) );

		$args = array(
			'labels'             => $labels,
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => $gs_books_slug, 'with_front' => $replace_custom_slug ),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => 41,
			'menu_icon'          => GS_BOOKS_PLUGIN_URI . '/assets/img/icon.svg',
			'supports'           => array( 'title', 'editor', 'thumbnail', 'comments' ),
		);

		if ( false ) {
			$args['register_meta_box_cb'] = array( 'Metabox_Gallery', 'gs-books-showcase_video_gal_metaboxes' );
		}

		register_post_type( 'gs_bookshowcase', $args );
	}

	public function theme_supports() {
		add_theme_support( 'post-thumbnails', array( 'gs_bookshowcase' ) );
		add_theme_support( 'post-thumbnails', array( 'post' ) );
		add_theme_support( 'post-thumbnails', array( 'page' ) );
		add_theme_support( 'post-thumbnails', array( 'product' ) );
		add_theme_support( 'post-thumbnails' );
		// add_filter( 'widget_text', 'do_shortcode' );
	}
}
