<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

$is_connected = Growffinity_CRM::get_instance()->is_connected();
$user_email = get_option('growffinity_user_email', '');
$store_id = get_option('growffinity_store_id', '');
$connected_at = get_option('growffinity_connected_at', '');
?>

<div class="wrap growffinity-admin-wrap">
    <h1><?php esc_html_e('Growffinity CRM for WooCommerce', 'growffinity-crm-for-woocommerce'); ?></h1>

    <?php if (!$is_connected) : ?>
        <!-- Connection Form -->
        <div class="growffinity-card">
            <div class="growffinity-card-header">
                <h2><?php esc_html_e('Connect Your Store to Growffinity', 'growffinity-crm-for-woocommerce'); ?></h2>
                <p><?php esc_html_e('Sync your WooCommerce customers and orders to Growffinity CRM automatically.', 'growffinity-crm-for-woocommerce'); ?></p>
            </div>

            <div class="growffinity-card-body">
                <form id="growffinity-connect-form" class="growffinity-form">
                    <div class="form-group">
                        <label for="growffinity-email"><?php esc_html_e('Growffinity Account Email', 'growffinity-crm-for-woocommerce'); ?></label>
                        <input
                            type="email"
                            id="growffinity-email"
                            name="email"
                            class="regular-text"
                            required
                            placeholder="your@email.com"
                        >
                        <p class="description">
                            <?php esc_html_e('Enter the email address you use to login to Growffinity.', 'growffinity-crm-for-woocommerce'); ?>
                        </p>
                    </div>

                    <div class="form-group">
                        <label for="growffinity-password"><?php esc_html_e('Password', 'growffinity-crm-for-woocommerce'); ?></label>
                        <input
                            type="password"
                            id="growffinity-password"
                            name="password"
                            class="regular-text"
                            required
                            placeholder="Enter your password"
                        >
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="button button-primary button-hero">
                            <span class="dashicons dashicons-cloud"></span>
                            <?php esc_html_e('Connect to Growffinity', 'growffinity-crm-for-woocommerce'); ?>
                        </button>
                    </div>

                    <div class="growffinity-notice" id="connection-notice" style="display: none;"></div>
                </form>

                <div class="growffinity-footer">
                    <p>
                        <?php esc_html_e("Don't have a Growffinity account?", 'growffinity-crm-for-woocommerce'); ?>
                        <a href="https://growffinity.com/pricing" target="_blank" class="button button-secondary">
                            <?php esc_html_e('Sign Up Free', 'growffinity-crm-for-woocommerce'); ?>
                        </a>
                    </p>
                </div>
            </div>
        </div>

        <!-- Features Section -->
        <div class="growffinity-features">
            <h2><?php esc_html_e('Why Connect to Growffinity?', 'growffinity-crm-for-woocommerce'); ?></h2>
            <div class="features-grid">
                <div class="feature-item">
                    <span class="dashicons dashicons-groups"></span>
                    <h3><?php esc_html_e('Customer Management', 'growffinity-crm-for-woocommerce'); ?></h3>
                    <p><?php esc_html_e('View all your WooCommerce customers in one powerful dashboard.', 'growffinity-crm-for-woocommerce'); ?></p>
                </div>
                <div class="feature-item">
                    <span class="dashicons dashicons-email-alt"></span>
                    <h3><?php esc_html_e('Email Campaigns', 'growffinity-crm-for-woocommerce'); ?></h3>
                    <p><?php esc_html_e('Send targeted email campaigns to your customer segments.', 'growffinity-crm-for-woocommerce'); ?></p>
                </div>
                <div class="feature-item">
                    <span class="dashicons dashicons-chart-line"></span>
                    <h3><?php esc_html_e('Analytics', 'growffinity-crm-for-woocommerce'); ?></h3>
                    <p><?php esc_html_e('Track CLV, churn rate, and other important metrics.', 'growffinity-crm-for-woocommerce'); ?></p>
                </div>
                <div class="feature-item">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <h3><?php esc_html_e('Automation', 'growffinity-crm-for-woocommerce'); ?></h3>
                    <p><?php esc_html_e('Create workflows to automate your marketing.', 'growffinity-crm-for-woocommerce'); ?></p>
                </div>
            </div>
        </div>

    <?php else : ?>
        <!-- Connected State -->
        <div class="growffinity-card growffinity-connected">
            <div class="growffinity-card-header">
                <div class="status-indicator">
                    <span class="dashicons dashicons-yes-alt"></span>
                    <span class="status-text"><?php esc_html_e('Connected', 'growffinity-crm-for-woocommerce'); ?></span>
                </div>
                <h2><?php esc_html_e('Your Store is Connected!', 'growffinity-crm-for-woocommerce'); ?></h2>
            </div>

            <div class="growffinity-card-body">
                <div class="connection-info">
                    <div class="info-row">
                        <span class="label"><?php esc_html_e('Account:', 'growffinity-crm-for-woocommerce'); ?></span>
                        <span class="value"><?php echo esc_html($user_email); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="label"><?php esc_html_e('Store ID:', 'growffinity-crm-for-woocommerce'); ?></span>
                        <span class="value"><?php echo esc_html($store_id); ?></span>
                    </div>
                    <?php if ($connected_at) : ?>
                    <div class="info-row">
                        <span class="label"><?php esc_html_e('Connected:', 'growffinity-crm-for-woocommerce'); ?></span>
                        <span class="value"><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($connected_at))); ?></span>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="action-buttons">
                    <a href="https://dashboard.growffinity.com" target="_blank" class="button button-primary button-hero">
                        <span class="dashicons dashicons-external"></span>
                        <?php esc_html_e('Open Growffinity Dashboard', 'growffinity-crm-for-woocommerce'); ?>
                    </a>

                    <button type="button" id="sync-now-btn" class="button button-secondary">
                        <span class="dashicons dashicons-update"></span>
                        <?php esc_html_e('Sync Now', 'growffinity-crm-for-woocommerce'); ?>
                    </button>
                </div>

                <div class="growffinity-notice" id="sync-notice" style="display: none;"></div>

                <div class="sync-info">
                    <h3><?php esc_html_e('Your Store is Connected!', 'growffinity-crm-for-woocommerce'); ?></h3>
                    <p>
                        <span class="dashicons dashicons-yes"></span>
                        <?php esc_html_e('Click "Sync Now" to send your customers and orders to Growffinity, then manage everything from the dashboard.', 'growffinity-crm-for-woocommerce'); ?>
                    </p>
                </div>

                <div class="disconnect-section">
                    <button type="button" id="disconnect-btn" class="button button-link-delete">
                        <?php esc_html_e('Disconnect Store', 'growffinity-crm-for-woocommerce'); ?>
                    </button>
                </div>
            </div>
        </div>

        <!-- Quick Stats (placeholder for future) -->
        <div class="growffinity-stats">
            <h2><?php esc_html_e('Need Advanced Features?', 'growffinity-crm-for-woocommerce'); ?></h2>
            <div class="upgrade-cta">
                <p><?php esc_html_e('Unlock email campaigns, automation workflows, advanced analytics, and more.', 'growffinity-crm-for-woocommerce'); ?></p>
                <a href="https://growffinity.com/pricing" target="_blank" class="button button-primary">
                    <?php esc_html_e('View Plans & Pricing', 'growffinity-crm-for-woocommerce'); ?>
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
