/**
 * Growffinity CRM Admin JavaScript
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Connect Form Submit
        $('#growffinity-connect-form').on('submit', function(e) {
            e.preventDefault();

            var $form = $(this);
            var $button = $form.find('button[type="submit"]');
            var $notice = $('#connection-notice');

            var email = $('#growffinity-email').val();
            var password = $('#growffinity-password').val();

            // Disable button and show loading
            $button.addClass('loading').prop('disabled', true);
            $notice.hide();

            $.ajax({
                url: growffinityData.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'growffinity_connect_store',
                    nonce: growffinityData.nonce,
                    email: email,
                    password: password
                },
                success: function(response) {
                    if (response.success) {
                        showNotice($notice, 'success', response.data.message);
                        // Reload page after 1 second
                        setTimeout(function() {
                            window.location.reload();
                        }, 1000);
                    } else {
                        showNotice($notice, 'error', response.data.message || 'Connection failed. Please try again.');
                        $button.removeClass('loading').prop('disabled', false);
                    }
                },
                error: function() {
                    showNotice($notice, 'error', 'An error occurred. Please try again.');
                    $button.removeClass('loading').prop('disabled', false);
                }
            });
        });

        // Disconnect Button
        $('#disconnect-btn').on('click', function(e) {
            e.preventDefault();

            if (!confirm('Are you sure you want to disconnect your store from Growffinity? Your data will remain in Growffinity, but new orders and customers will not be synced.')) {
                return;
            }

            var $button = $(this);
            $button.addClass('loading').prop('disabled', true);

            $.ajax({
                url: growffinityData.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'growffinity_disconnect_store',
                    nonce: growffinityData.nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Reload page
                        window.location.reload();
                    } else {
                        alert(response.data.message || 'Disconnection failed.');
                        $button.removeClass('loading').prop('disabled', false);
                    }
                },
                error: function() {
                    alert('An error occurred. Please try again.');
                    $button.removeClass('loading').prop('disabled', false);
                }
            });
        });

        // Sync Now Button
        $('#sync-now-btn').on('click', function(e) {
            e.preventDefault();

            var $button = $(this);
            var $notice = $('#sync-notice');

            $button.addClass('loading').prop('disabled', true);
            $notice.hide();

            $.ajax({
                url: growffinityData.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'growffinity_sync_now',
                    nonce: growffinityData.nonce
                },
                success: function(response) {
                    if (response.success) {
                        showNotice($notice, 'success', response.data.message);
                    } else {
                        showNotice($notice, 'error', response.data.message || 'Sync failed. Please try again.');
                    }
                    $button.removeClass('loading').prop('disabled', false);
                },
                error: function() {
                    showNotice($notice, 'error', 'An error occurred. Please try again.');
                    $button.removeClass('loading').prop('disabled', false);
                }
            });
        });

        /**
         * Show notice
         */
        function showNotice($notice, type, message) {
            $notice
                .removeClass('success error')
                .addClass(type)
                .html(message)
                .fadeIn();
        }
    });

})(jQuery);
