<?php
/**
 * groups-admin-options-legacy.php
 *
 * Copyright (c) "kento" Karim Rahimpur www.itthinx.com
 *
 * This code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This header and all notices must be kept intact.
 *
 * @author Karim Rahimpur
 * @package groups
 * @since groups 2.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable PluginCheck.Security.DirectDB.UnescapedDBParameter, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

/**
 * Legacy options admin screen extension.
 * @param $legacy_switched boolean whether legacy mode setting has been changed during submit
 */
function groups_admin_options_legacy( $legacy_switched ) {

	global $wpdb;

	require_once GROUPS_LEGACY_LIB . '/access/class-groups-post-access-legacy.php';

	//
	// handle legacy options after form submission
	//
	if ( groups_sanitize_post( 'submit' ) && !$legacy_switched ) {
		if ( groups_verify_post_nonce( GROUPS_ADMIN_OPTIONS_NONCE, 'admin' ) ) {
			$valid_read_caps = array( Groups_Post_Access_Legacy::READ_POST_CAPABILITY );
			$read_caps = groups_sanitize_post( GROUPS_READ_POST_CAPABILITIES );
			if ( is_array( $read_caps ) ) {
				foreach ( $read_caps as $read_cap ) {
					$read_cap = sanitize_text_field( $read_cap );
					if ( $valid_cap = Groups_Capability::read( $read_cap ) ) {
						if ( !in_array( $valid_cap->capability, $valid_read_caps ) ) {
							$valid_read_caps[] = $valid_cap->capability;
						}
					}
				}
			}
			Groups_Options::update_option( Groups_Post_Access_Legacy::READ_POST_CAPABILITIES, $valid_read_caps );
		}
	}

	//
	// render legacy settings
	//
	echo '<h3>' . esc_html__( 'Capabilities', 'groups' ) . '</h3>';

	echo '<p class="description">' .
		esc_html__( 'Include these capabilities to enforce read access on posts. The selected capabilities will be offered to restrict access to posts.', 'groups' ) .
		'</p>';

	$capability_table = _groups_get_tablename( 'capability' );
	$capabilities = $wpdb->get_results( "SELECT * FROM $capability_table ORDER BY capability" ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	$applicable_read_caps = Groups_Options::get_option( Groups_Post_Access_Legacy::READ_POST_CAPABILITIES, array( Groups_Post_Access_Legacy::READ_POST_CAPABILITY ) );
	echo '<div class="select-capability-container" style="width:62%;">';
	printf( '<select class="select capability" name="%s" multiple="multiple">', esc_attr( GROUPS_READ_POST_CAPABILITIES . '[]' ) );
	foreach ( $capabilities as $capability ) {
		$selected = in_array( $capability->capability, $applicable_read_caps ) ? ' selected="selected" ' : '';
		if ( $capability->capability == Groups_Post_Access_Legacy::READ_POST_CAPABILITY ) {
			$selected .= ' disabled="disabled" ';
		}
		printf( '<option value="%s" %s>%s</option>', esc_attr( $capability->capability_id ), $selected, stripslashes( wp_filter_nohtml_kses( $capability->capability ) ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
	echo '</select>';
	echo '</div>'; // .select-capability-container

	echo Groups_UIE::render_select( '.select.capability' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

}

add_action( 'groups_admin_options_legacy', 'groups_admin_options_legacy' );
