<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! function_exists( 'grlca_setup_dashboard' ) ) {

    function grlca_get_active_plugins() {
        $active_plugins = get_option( 'active_plugins', array() );
        $grlca_plugins = array();
        
        foreach ( $active_plugins as $plugin ) {
            $plugin_slug = explode( '/', $plugin );
            if ( ! empty( $plugin_slug[0] ) && strpos( $plugin_slug[0], 'grlca-' ) === 0 ) {
                $plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/' . $plugin );
                $grlca_plugins[] = array(
                    'file' => $plugin,
                    'name' => $plugin_data['Name'],
                    'slug' => $plugin_slug[0]
                );
            }
        }
        
        return $grlca_plugins;
    }

    function grlca_setup_dashboard() {
        $grlca_plugins = grlca_get_active_plugins();
        
        if ( empty( $grlca_plugins ) ) {
            return;
        }
        
        global $menu;
        $menu_exists = false;
        
        foreach ( $menu as $menu_item ) {
            if ( isset( $menu_item[2] ) && $menu_item[2] === 'grlca-dashboard' ) {
                $menu_exists = true;
                break;
            }
        }
        
        if ( $menu_exists ) {
            return;
        }
        
        add_menu_page(
            esc_html__( "GrL'Ca Dashboard", 'grlca-search-for-woocommerce' ),
            esc_html__( "GrL'Ca", 'grlca-search-for-woocommerce' ),
            'manage_options',
            'grlca-dashboard',
            'grlca_display_dashboard',
            'dashicons-admin-generic',
            58
        );
        
        add_submenu_page(
            'grlca-dashboard',
            esc_html__( 'Dashboard', 'grlca-search-for-woocommerce' ),
            esc_html__( 'Dashboard', 'grlca-search-for-woocommerce' ),
            'manage_options',
            'grlca-dashboard',
            'grlca_display_dashboard'
        );
    }

    add_action( 'admin_menu', 'grlca_setup_dashboard' );

    function grlca_display_dashboard() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'grlca-search-for-woocommerce' ) );
        }
        
        $grlca_plugins = grlca_get_active_plugins();
        ?>
        <div class="wrap">
            <h1><?php echo esc_html__( "GrL'Ca Dashboard", 'grlca-search-for-woocommerce' ); ?></h1>
            
            <div class="grlca-dashboard-container">
                <div class="card">
                    <h2><?php echo esc_html__( "Welcome to GrL'Ca Plugins", 'grlca-search-for-woocommerce' ); ?></h2>
                    <p><?php echo esc_html__( 'Thank you for using our plugins. Below you can find information about your active GrL\'Ca plugins.', 'grlca-search-for-woocommerce' ); ?></p>
                </div>
                
                <div class="card">
                    <h2><?php echo esc_html__( 'Active GrL\'Ca Plugins', 'grlca-search-for-woocommerce' ); ?></h2>
                    <?php if ( ! empty( $grlca_plugins ) ) : ?>
                        <table class="wp-list-table widefat fixed striped">
                            <thead>
                                <tr>
                                    <th><?php echo esc_html__( 'Plugin', 'grlca-search-for-woocommerce' ); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ( $grlca_plugins as $plugin ) : ?>
                                    <tr>
                                        <td><strong><?php echo esc_html( $plugin['name'] ); ?></strong></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else : ?>
                        <p><?php echo esc_html__( 'No GrL\'Ca plugins are currently active.', 'grlca-search-for-woocommerce' ); ?></p>
                    <?php endif; ?>
                </div>
                
                <div class="card">
                    <h2><?php echo esc_html__( 'Support & Documentation', 'grlca-search-for-woocommerce' ); ?></h2>
                    <p><?php echo esc_html__( 'For complete documentation, support, and more plugins, visit our documentation page:', 'grlca-search-for-woocommerce' ); ?></p>
                    <p><a href="https://grlca.com/grlca-wordpress-plugins/" target="_blank" class="button button-primary"><?php echo esc_html__( 'View Documentation', 'grlca-search-for-woocommerce' ); ?></a></p>
                </div>
            </div>
            
            <style>
            .grlca-dashboard-container {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
                gap: 20px;
                margin-top: 20px;
            }
            .card {
                background: #fff;
                border: 1px solid #ccd0d4;
                border-radius: 8px;
                padding: 20px;
                box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            }
            .card h2 {
                margin-top: 0;
                color: #2271b1;
                border-bottom: 2px solid #2271b1;
                padding-bottom: 10px;
            }
            .card table {
                margin-top: 10px;
            }
            </style>
        </div>
        <?php
    }

}