<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://profiles.wordpress.org/rityunjay/
 * @since      1.0.0
 *
 * @package    Grit_Portfolio
 * @subpackage Grit_Portfolio/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Grit_Portfolio
 * @subpackage Grit_Portfolio/public
 * @author     Rityunjay <rityunjay@gmail.com>
 */
class Grit_Portfolio_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		$this->grit_portfolio_options = get_option($this->plugin_name);

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Grit_Portfolio_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Grit_Portfolio_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/grit-portfolio-public.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'font-awesome', plugin_dir_url( __FILE__ ) . 'assets/css/font-awesome.min.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'animate', plugin_dir_url( __FILE__ ) . 'assets/css/animate.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'magnific-popup', plugin_dir_url( __FILE__ ) . 'assets/css/magnific-popup.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'owl-carousel', plugin_dir_url( __FILE__ ) . 'assets/css/owl.carousel.min.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'style', plugin_dir_url( __FILE__ ) . 'assets/css/style.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'responsive', plugin_dir_url( __FILE__ ) . 'assets/css/responsive.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Grit_Portfolio_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Grit_Portfolio_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/grit-portfolio-public.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( $this->plugin_name . 'pop-up', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.magnific-popup.min.js', array( 'jquery' ), $this->version, true );
		
		wp_enqueue_script( $this->plugin_name . 'owl.carousel', plugin_dir_url( __FILE__ ) . 'assets/js/owl.carousel.min.js', array( 'jquery' ), $this->version, true );

		wp_enqueue_script( $this->plugin_name . 'wow', plugin_dir_url( __FILE__ ) . 'assets/js/wow.min.js', array( 'jquery' ), $this->version, true );
		
		wp_enqueue_script( $this->plugin_name . 'isotop', plugin_dir_url( __FILE__ ) . 'assets/js/isotope.pkgd.min.js', array( 'jquery' ), $this->version, true );

		wp_enqueue_script( $this->plugin_name . 'imagesload', plugin_dir_url( __FILE__ ) . 'assets/js/imagesloaded.pkgd.min.js', array( 'jquery' ), $this->version, true );

		wp_enqueue_script( $this->plugin_name . 'main', plugin_dir_url( __FILE__ ) . 'assets/js/main.js', array( 'jquery' ), $this->version, true );

	}


	
	public function register_shortcodes() {
		add_shortcode( 'GRIT-Port', array( $this, 'grit_portfolio_display') );
	}

	function grit_portfolio_display(){?>
		<?php ob_start(); ?>
		<!-- Star Portfolio
	    ============================================= -->
	    <?php

	        $args=array('post_type' => 'grit-portfolio', 'posts_per_page'=>-1, 'order' => 'ASC', 'post_status' => 'publish',) ;
	        $the_qyery= new WP_Query($args);?>
	    <?php if ($the_qyery->have_posts()) : ?>
	    	<!-- grid-view-start -->
	    	<?php if (get_option($this->plugin_name.'-radio') == 'g3c'): ?>
		    <div class="gtportfolio-area default-padding">
		        <div class="container">
		            <div class="gtgallery-items-area">
		                <div class="row">
		                    <div class="col-md-12 gtgallery-content">
		                        <div class="mix-item-menu text-center">
		                            <?php
		                               $i=0;
		                               $tax_terms = get_terms('portfolio_cat', array('hide_empty' => '0'));
		                               foreach ( $tax_terms as $tax_term ):
		                            ?>
		                            <button class="<?php if($i=='0') { $i=1; echo 'active'; }?>" data-filter=".<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></button>
		                            <?php endforeach;  ?>
		                        </div>
		                        <!-- End Mixitup Nav-->

		                        <div class="row magnific-mix-gtgallery masonary">
		                            <div id="portfolio-grid" class="gtgallery-items col-3">
		                                <!-- Single Item -->
		                                <?php while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
		                                	global $post;
		                                    $image = get_the_post_thumbnail_url($post->ID, 'full');
			                                // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
			                                $image_id = get_post_thumbnail_id();

			                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);

			                                $image_title = get_the_title($image_id);
		                                ?>
		                                <div class="pf-item <?php $terms = get_the_terms( $post->ID , 'portfolio_cat' );
		                                    foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>">
		                                    <div class="effect-box">
		                                        <div class="thumb">
		                                            <img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
		                                        </div>
		                                        <div class="info">
		                                            <div class="left">
		                                                <h4><a><?php the_title(); ?></a></h4>
		                                                
		                                            </div>
		                                            <div class="right">
		                                                <a href="<?php echo $image; ?>" class="item popup-link"><i class="fa fa-plus"></i></a>
		                                            </div>
		                                        </div>
		                                    </div>
		                                </div>
		                                <?php endwhile; wp_reset_query(); ?>
		                                <!-- End Single Item -->
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <?php elseif (get_option($this->plugin_name.'-radio') == 'g2c'): ?>
		    <!-- Star Portfolio
			============================================= -->
			<div class="gtportfolio-area default-padding">
			        <div class="container">
			            <div class="gtgallery-items-area">
			                <div class="row">
			                    <div class="col-md-12 gtgallery-content">
			                        <div class="mix-item-menu text-center">
			                        	<?php
			                               $i=0;
			                               $tax_terms = get_terms('portfolio_cat', array('hide_empty' => '0'));
			                               foreach ( $tax_terms as $tax_term ):
		                            	?>
			                            	<button class="<?php if($i=='0') { $i=1; echo 'active'; }?>" data-filter=".<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></button>
			                            <?php endforeach;  ?>
			                        </div>
			                        <!-- End Mixitup Nav-->

			                        <div class="row magnific-mix-gtgallery masonary">
			                            <div id="portfolio-grid" class="gtgallery-items col-2">
			                                <!-- Single Item -->
			                                <?php 
				                                while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
			                                	global $post;
			                                    $image = get_the_post_thumbnail_url($post->ID, 'full');
				                                // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
				                                $image_id = get_post_thumbnail_id();

				                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);

				                                $image_title = get_the_title($image_id);
		                                	?>
			                                <div class="pf-item <?php $terms = get_the_terms( $post->ID , 'portfolio_cat' );
		                                    foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>">
			                                    <div class="effect-box">
			                                        <div class="thumb">
			                                            <img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
			                                        </div>
			                                        <div class="info">
			                                            <div class="left">
			                                                <h4><a><?php the_title(); ?></a></h4>
			                                            </div>
			                                            <div class="right">
			                                                <a href="<?php echo $image; ?>" class="item popup-link"><i class="fa fa-plus"></i></a>
			                                            </div>
			                                        </div>
			                                    </div>
			                                </div>
			                                <?php endwhile; wp_reset_query(); ?>
			                                <!-- End Single Item -->
			                            </div>
			                        </div>
			                    </div>
			                </div>
			            </div>
			        </div>
			</div>
			<!-- End Portfolio -->
			<?php elseif (get_option($this->plugin_name.'-radio') == 'g4c'): ?>
			<!-- Star Portfolio
		    ============================================= -->
		    <div class="gtportfolio-area default-padding">
		        <div class="container">
		            <div class="gtgallery-items-area">
		                <div class="row">
		                    <div class="col-md-12 gtgallery-content">
		                        <div class="mix-item-menu text-center">
		                            <?php
			                           $i=0;
			                            $tax_terms = get_terms('portfolio_cat', array('hide_empty' => '0'));
			                            foreach ( $tax_terms as $tax_term ):
		                            	?>
		                            	<button class="<?php if($i=='0') { $i=1; echo 'active'; }?>" data-filter=".<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></button>
			                        <?php endforeach;  ?>
		                        </div>
		                        <!-- End Mixitup Nav-->

		                        <div class="row magnific-mix-gtgallery masonary">
		                            <div id="portfolio-grid" class="gtgallery-items col-4">
		                                <!-- Single Item -->
		                                <?php 
				                            while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
			                               	global $post;
			                                $image = get_the_post_thumbnail_url($post->ID, 'full');
				                            // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
				                            $image_id = get_post_thumbnail_id();
				                            $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
				                            $image_title = get_the_title($image_id);
		                                ?>
		                                <div class="pf-item <?php $terms = get_the_terms( $post->ID , 'portfolio_cat' );
		                                    foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>">
		                                    <div class="effect-box">
		                                        <div class="thumb">
		                                            <img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
		                                        </div>
		                                        <div class="info">
		                                            <div class="left">
		                                                <h4><a><?php the_title(); ?></a></h4>
		                                            </div>
		                                            <div class="right">
		                                                <a href="<?php echo $image; ?>" class="item popup-link"><i class="fa fa-plus"></i></a>
		                                            </div>
		                                        </div>
		                                    </div>
		                                </div>
		                                <?php endwhile; wp_reset_query(); ?>
		                                <!-- End Single Item -->
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <!-- End Portfolio -->
		    <!-- grid-view-end -->
		    <!-- masonary-view-start -->
		    <?php elseif (get_option($this->plugin_name.'-radio') == 'm2c'): ?>
		    <!-- Star Portfolio
		    ============================================= -->
		    <div class="gtportfolio-area default-padding">
		        <div class="container">
		            <div class="gtgallery-items-area">
		                <div class="row">
		                    <div class="col-md-12 gtgallery-content">
		                        <div class="mix-item-menu text-center">
		                            <?php
			                           $i=0;
			                            $tax_terms = get_terms('portfolio_cat', array('hide_empty' => '0'));
			                            foreach ( $tax_terms as $tax_term ):
		                            	?>
		                            	<button class="<?php if($i=='0') { $i=1; echo 'active'; }?>" data-filter=".<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></button>
			                        <?php endforeach;  ?>
		                        </div>
		                        <!-- End Mixitup Nav-->

		                        <div class="row magnific-mix-gtgallery masonary">
		                            <div id="portfolio-grid" class="gtgallery-items col-2">
		                                <!-- Single Item -->
		                                <?php 
				                            while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
			                               	global $post;
			                                $image = get_the_post_thumbnail_url($post->ID, 'full');
				                            // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
				                            $image_id = get_post_thumbnail_id();
				                            $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
				                            $image_title = get_the_title($image_id);
		                                ?>
		                                <div class="pf-item <?php $terms = get_the_terms( $post->ID , 'portfolio_cat' );
		                                    foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>">
		                                    <div class="effect-box">
		                                        <div class="thumb">
		                                            <img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
		                                        </div>
		                                        <div class="info">
		                                            <div class="left">
		                                                <h4><a><?php the_title(); ?></a></h4>
		                                            </div>
		                                            <div class="right">
		                                                <a href="<?php echo $image; ?>" class="item popup-link"><i class="fa fa-plus"></i></a>
		                                            </div>
		                                        </div>
		                                    </div>
		                                </div>
		                                <?php endwhile; wp_reset_query(); ?>
		                                <!-- End Single Item -->
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <!-- End Portfolio -->
		    <?php elseif (get_option($this->plugin_name.'-radio') == 'm3c'): ?>
		    <!-- Star Portfolio
		    ============================================= -->
		    <div class="gtportfolio-area default-padding">
		        <div class="container">
		            <div class="gtgallery-items-area">
		                <div class="row">
		                    <div class="col-md-12 gtgallery-content">
		                        <div class="mix-item-menu text-center">
		                            <?php
			                           $i=0;
			                            $tax_terms = get_terms('portfolio_cat', array('hide_empty' => '0'));
			                            foreach ( $tax_terms as $tax_term ):
		                            	?>
		                            	<button class="<?php if($i=='0') { $i=1; echo 'active'; }?>" data-filter=".<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></button>
			                        <?php endforeach;  ?>
		                        </div>
		                        <!-- End Mixitup Nav-->

		                        <div class="row magnific-mix-gtgallery masonary">
		                            <div id="portfolio-grid" class="gtgallery-items col-3">
		                                <!-- Single Item -->
		                                <?php 
				                            while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
			                               	global $post;
			                                $image = get_the_post_thumbnail_url($post->ID, 'full');
				                            // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
				                            $image_id = get_post_thumbnail_id();
				                            $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
				                            $image_title = get_the_title($image_id);
		                                ?>
		                                <div class="pf-item <?php $terms = get_the_terms( $post->ID , 'portfolio_cat' );
		                                    foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>">
		                                    <div class="effect-box">
		                                        <div class="thumb">
		                                            <img src="<?php echo $image; ?>" alt="<?php $image_alt; ?>">
		                                        </div>
		                                        <div class="info">
		                                            <div class="left">
		                                                <h4><a><?php the_title(); ?></a></h4>
		                                            </div>
		                                            <div class="right">
		                                                <a href="<?php echo $image; ?>" class="item popup-link"><i class="fa fa-plus"></i></a>
		                                            </div>
		                                        </div>
		                                    </div>
		                                </div>
		                                <?php endwhile; wp_reset_query(); ?>
		                                <!-- End Single Item -->
		                                
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <!-- End Portfolio -->
		    <?php elseif (get_option($this->plugin_name.'-radio') == 'm4c'): ?>
		    <!-- Star Portfolio
		    ============================================= -->
		    <div class="gtportfolio-area default-padding">
		        <div class="container">
		            <div class="gtgallery-items-area">
		                <div class="row">
		                    <div class="col-md-12 gtgallery-content">
		                        <div class="mix-item-menu text-center">
		                            <?php
		                                $i=0;
		                                $tax_terms = get_terms('portfolio_cat', array('hide_empty' => '0'));
		                                foreach ( $tax_terms as $tax_term ):
		                            ?>
		                                <button class="<?php if($i=='0') { $i=1; echo 'active'; }?>" data-filter=".<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></button>
		                            <?php endforeach;  ?>
		                        </div>
		                        <!-- End Mixitup Nav-->

		                        <div class="row magnific-mix-gtgallery masonary">
		                            <div id="portfolio-grid" class="gtgallery-items col-4">
		                                <!-- Single Item -->
		                                <?php 
		                                    while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
		                                    global $post;
		                                    $image = get_the_post_thumbnail_url($post->ID, 'full');
		                                    // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
		                                    $image_id = get_post_thumbnail_id();
		                                    $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
		                                    $image_title = get_the_title($image_id);
		                                ?>
		                                <div class="pf-item <?php $terms = get_the_terms( $post->ID , 'portfolio_cat' );
		                                            foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>">
		                                    <div class="effect-box">
		                                        <div class="thumb">
		                                            <img src="<?php echo $image; ?>" alt="<?php echo $image_alt;?>">
		                                        </div>
		                                        <div class="info">
		                                            <div class="left">
		                                                <h4><a><?php the_title(); ?></a></h4>
		                                            </div>
		                                            <div class="right">
		                                               <a href="<?php echo $image; ?>" class="item popup-link"><i class="fa fa-plus"></i></a>
		                                            </div>
		                                        </div>
		                                    </div>
		                                </div>
		                                <?php endwhile; wp_reset_query(); ?>
		                                <!-- End Single Item -->
		                                
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <!-- End Portfolio -->
		    <!-- masonary-view-end -->
		    <!-- carousel-view-start -->
		    <?php elseif (get_option($this->plugin_name.'-radio') == 'carousel'): ?>
		    <!-- Star Portfolio
		    ============================================= -->
		    <div class="gtportfolio-area gtgallery-carousel default-padding">
		        <div class="container-full">
		            <div class="gtgallery-items-area">
		                <div class="col-md-12 gtgallery-content">

		                    <div class="row magnific-mix-gtgallery masonary">
		                        <div class="gtgallery-items gtportfolio-carousel owl-carousel owl-theme">
		                            <!-- Single Item -->
		                            <?php 
		                                while ( $the_qyery->have_posts() ) : $the_qyery->the_post();
		                                global $post;
		                                $image = get_the_post_thumbnail_url($post->ID, 'full');
		                                // An attachment/image ID is all that's needed to retrieve its alt and title attributes.
		                                $image_id = get_post_thumbnail_id();
		                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
		                                $image_title = get_the_title($image_id);
		                            ?>
		                            <div class="pf-item">
		                                <div class="effect-box">
		                                    <div class="thumb">
		                                        <img src="<?php echo $image;?>" alt="<?php echo $image_alt;?>">
		                                    </div>
		                                    <div class="info">
		                                        <div class="left">
		                                            <h4><a><?php the_title(); ?></a></h4>
		                                        </div>
		                                        <div class="right">
		                                            <a href="<?php echo $image;?>" class="item popup-link"><i class="fa fa-plus"></i></a>
		                                        </div>
		                                    </div>
		                                </div>
		                            </div>
		                            <?php endwhile; wp_reset_query(); ?>
		                            <!-- End Single Item -->
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <!-- End Portfolio -->
		    <!-- carousel-view-end -->
			<?php endif; ?>

	    <?php endif; ?>
	    <!-- End Portfolio -->
	    <?php return ob_get_clean(); ?>
	<?php }

}
