<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://profiles.wordpress.org/rityunjay/
 * @since      1.0.0
 *
 * @package    Grit_Portfolio
 * @subpackage Grit_Portfolio/admin/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">
	<fieldset>
		<h3>Use shortcode [GRIT-Port] in your posts or pages.</h3>
        <p><strong style="color:#ff6a00;">Note: Use equal sized images for GRID and CAROUSEL settings. For MASONRY un-equal sized images is fine.</strong></p>
	</fieldset>
	<hr/>
	<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>

	<form method="post" name="cleanup_options" action="options.php">
		<?php 
			$options = get_option($this->plugin_name);
			wp_nonce_field('update-options');
		?>
	   	<div class="tabordion">
	    	<section id="section1">
	        	<input type="radio" name="sections" id="option1" checked>
	         	<label for="option1">Grid Colum View</label>
	         	<article>
	            	<div class="c-33">
						<div class="checkboxes-and-radios">
					  		<h3 class="h3-heading">Grid Colum View</h3>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-1" value="g2c" <?php if (get_option($this->plugin_name.'-radio') == 'g2c') echo 'checked="checked"'; ?>>
					  		<label for="radio-1">2 Colum</label>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-2" value="g3c" <?php if (get_option($this->plugin_name.'-radio') == 'g3c') echo 'checked="checked"'; ?>>
					  		<label for="radio-2">3 Colum</label>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-3" value="g4c" <?php if (get_option($this->plugin_name.'-radio') == 'g4c') echo 'checked="checked"'; ?>>
					  		<label for="radio-3">4 Colum</label>
						</div>
					</div>
	         	</article>
	      	</section>
	      	<section id="section2">
	         	<input type="radio" name="sections" id="option2">
	         	<label for="option2">Masonary Colum View</label>
	         	<article>
	            	<div class="c-33">
						<div class="checkboxes-and-radios">
					  		<h3 class="h3-heading">Masonary Colum View</h3>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-1-1" value="m2c" <?php if (get_option($this->plugin_name.'-radio') == 'm2c') echo 'checked="checked"'; ?>>
					  		<label for="radio-1-1">2 Colum</label>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-2-1" value="m3c" <?php if (get_option($this->plugin_name.'-radio') == 'm3c') echo 'checked="checked"'; ?>>
					  		<label for="radio-2-1">3 Colum</label>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-3-1" value="m4c" <?php if (get_option($this->plugin_name.'-radio') == 'm4c') echo 'checked="checked"'; ?>>
					  		<label for="radio-3-1">4 Colum</label>
						</div>
					</div>
	         	</article>
	      	</section>
	      	<section id="section3">
	         	<input type="radio" name="sections" id="option3">
	         	<label for="option3">Carousel View</label>
	         	<article>
	            	<div class="c-33">
						<div class="checkboxes-and-radios">
					  		<h3 class="h3-heading">Carousel View</h3>
					  		<input type="radio" name="<?php echo $this->plugin_name.'-radio'; ?>" id="radio-1-2" value="carousel" <?php if (get_option($this->plugin_name.'-radio') == 'carousel') echo 'checked="checked"'; ?>>
					  		<label for="radio-1-2">Carousel View</label>
						</div>
					</div>
	         	</article>
	      	</section>
	      	
	      
	   	</div>

	   	<input type="hidden" name="action" value="update" />
		<input type="hidden" name="page_options" value="<?php echo $this->plugin_name.'-radio'; ?>" />

		<div class="c-100">
			<ul class="">
				<li class="">
					<?php submit_button(__('Save all changes', $this->plugin_name), 'primary','submit', TRUE); ?>
				</li>
			</ul>
           
        </div>
   	</form>
</div>