<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://profiles.wordpress.org/rityunjay/
 * @since      1.0.0
 *
 * @package    Grit_Portfolio
 * @subpackage Grit_Portfolio/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Grit_Portfolio
 * @subpackage Grit_Portfolio/admin
 * @author     Rityunjay <rityunjay@gmail.com>
 */
class Grit_Portfolio_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Grit_Portfolio_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Grit_Portfolio_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/grit-portfolio-admin.css', array(), $this->version, 'all' );

		wp_enqueue_style( $this->plugin_name . 'admin', plugin_dir_url( __FILE__ ) . 'assets/admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Grit_Portfolio_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Grit_Portfolio_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/grit-portfolio-admin.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( $this->plugin_name . 'admin', plugin_dir_url( __FILE__ ) . 'assets/admin.js', array( 'jquery' ), $this->version, false );

	}


	/**
		* Add admin menu 
		*/	
	public function add_plugin_admin_menu() {

    /*
     * Add a settings page for this plugin to the Settings menu.
     *
     * NOTE:  Alternative menu locations are available via WordPress administration menu functions.
     *
     *        Administration Menus: http://codex.wordpress.org/Administration_Menus
     *
     */
    add_options_page( 'GRIT Portfolio', 'GRIT Portfolio', 'manage_options', $this->plugin_name, array($this, 'display_plugin_setup_page')
    );
	}
	 /**
	* Add settings action link to the plugins page.
	*
	* @since    1.0.0
	*/

	public function add_action_links( $links ) {
    /*
    *  Documentation : https://codex.wordpress.org/Plugin_API/Filter_Reference/plugin_action_links_(plugin_file_name)
    */
   $settings_link = array(
    '<a href="' . admin_url( 'options-general.php?page=' . $this->plugin_name ) . '">' . __('Settings', $this->plugin_name) . '</a>',
   );
   return array_merge(  $settings_link, $links );

	}
	/**
	* Render the settings page for this plugin.
	*
	* @since    1.0.0
	*/

	public function display_plugin_setup_page() {
    include_once( 'partials/grit-portfolio-admin-display.php' );
}

	//Update input fields
 public function options_update() {
    register_setting($this->plugin_name, $this->plugin_name, array($this, 'validate'));
 }

	/**
	* Validate input 
	*/
	
public function validate($input) {
    // All checkboxes inputs        
    $valid = array();

    //Cleanup
  
    $valid['post_type'] = esc_html($input['post_type']);
	$valid['taxonomy_name'] = esc_html($input['taxonomy_name']);

    return $valid;
 }

	/* Register Post Type Portfolio */
	function grit_portfolio_init() {
	    $labels = array(
	        'name'               => _x( 'GRIT Portfolio', 'post type general name', 'grit' ),
	        'singular_name'      => _x( 'GRIT Portfolio', 'post type singular name', 'grit' ),
	        'add_new'            => 'Add GRIT Portfolio',
	        'all_items'          => 'All GRIT Portfolio',
	        'edit_item'          =>'Edit GRIT Portfolio',
	    );
	    $args = array(
	        'labels'             => $labels,
	        'description'        => __( 'GRIT Portfolio', 'grit' ),
	        'public'             => true,
	        'publicly_queryable' => true,
	        'show_ui'            => true,
	        'show_in_menu'       => true,
	        'query_var'          => true,
	        'rewrite'            => array( 'slug' => 'grit-portfolio' ),
	        'hierarchical'       => false,
	        'capability_type'    => 'post',
	        'has_archive'        => false,
	        'menu_position'      => 5,
	        'menu_icon'          => plugin_dir_url( __FILE__ ) .'assets/favicon.ico',
	        'supports'           => array( 'title', 'author', 'thumbnail' )
	    );
	    register_post_type( 'grit-portfolio', $args );
	}
	
	function grit_portfolio_cat_taxonomy() {
	    register_taxonomy(
	        'portfolio_cat',
	        'grit-portfolio',
	        array(
	            'label' => 'Category',
	            'hierarchical' => true,
	            'rewrite' => array( 'slug' => 'portfolio_cat' ),
	        )
	    );
	    flush_rewrite_rules();
	}



	/**
	 * Remove the slug from published post permalinks. Only affect our CPT though.
	*/
	function grit_portfolio_remove_slug( $post_link, $post, $leavename ) {

	    if ( ! in_array( $post->post_type, array( 'grit-portfolio' ) ) || 'publish' != $post->post_status )
	        return $post_link;

	    $post_link = str_replace( '/' . $post->post_type . '/', '/', $post_link );

	    return $post_link;
	}


	function grit_portfolio_request_tricksy( $query ) {

	    // Only noop the main query
	    if ( ! $query->is_main_query() )
	        return;

	    // Only noop our very specific rewrite rule match
	    if ( 2 != count( $query->query )
	        || ! isset( $query->query['page'] ) )
	        return;

	    // 'name' will be set if post permalinks are just post_name, otherwise the page rule will match
	    if ( ! empty( $query->query['name'] ) )
	        $query->set( 'post_type', array( 'post', 'grit-portfolio', 'page' ) );
	}
	

}
