<?php 

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/* Remember Me Function */
add_action( 'login_enqueue_scripts', 'graylc_enqueue_login_rememberme_script' );
function graylc_enqueue_login_rememberme_script() {
    if ( ! get_option( 'graylc_remember_me' ) ) return;
    
    wp_register_script(  'graylc-rememberme', '',  array(), GRAYLC_VERSION, true  );

    $inline_js = "
    document.addEventListener('DOMContentLoaded', function() {
        var rememberMe = document.getElementById('rememberme');
        if ( rememberMe ) {
            rememberMe.checked = true;
        }
    });
    ";
    wp_add_inline_script( 'graylc-rememberme', $inline_js );
    wp_enqueue_script( 'graylc-rememberme' );
}


/* Login Redirect Function */
function graylc_login_logo_url() {

    $graylc_login_url = get_option('graylc_logo_url_redirect');

    if(!empty($graylc_login_url)){
        return $graylc_login_url;
    }else{
        return home_url();
    }

    return home_url();
}
add_filter( 'login_headerurl', 'graylc_login_logo_url' );


/* Login Logo Title Function */
function graylc_login_logo_url_title() {

    $graylc_login_text = get_option('graylc_logo_text');

    return $graylc_login_text ?: '';

}
add_filter( 'login_headertext', 'graylc_login_logo_url_title' );
