<?php


// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action('customize_register','graylc_customizer_register');
function graylc_customizer_register( $wp_customize ) {
   
$wp_customize->add_panel( 'glc-panels', array(
    'title'       => __( 'Gray Login Customize', 'gray-login-customizer' ),
    'description' => __( 'Easily Customize Login form for your WordPress', 'gray-login-customizer' ),
    'priority' => 160, // Mixed with top-level-section hierarchy.
) );


require_once GRAYLC_PLUGIN_PATH . 'inc/customizer-controls/glc-templates.php';    
require_once GRAYLC_PLUGIN_PATH . 'inc/customizer-controls/glc-logo.php';    
require_once GRAYLC_PLUGIN_PATH . 'inc/customizer-controls/glc-bg.php';    
require_once GRAYLC_PLUGIN_PATH . 'inc/customizer-controls/glc-styles.php';    

}
add_action( 'login_enqueue_scripts', 'graylc_custom_login_styles' );
function graylc_custom_login_styles() {

    // Enqueue main CSS file
    wp_enqueue_style( 'graylc-login', GRAYLC_PLUGIN_URL . 'assets/front/front-end.css', array(), '1.0.0' );

    // Build raw CSS string from options
    $css = '';

    $form_width = get_option( 'graylc_form_width' );
    if ( $form_width ) {
        $css .= "#login { width: {$form_width}px; max-width: {$form_width}px; }";
    }

    $logo = get_option( 'graylc_login_logo' );
    if ( $logo ) {
        $css .= "#login h1 a { background-image: url('{$logo}'); }";
    }

    $bg = get_option( 'graylc_bg_image' );
    if ( $bg ) {
        $css .= "body.login { background-image: url('{$bg}'); }";
    }

    $logo_w = get_option( 'graylc_logo_width' );
    if ( $logo_w ) {
        $css .= ".login h1 a { width: {$logo_w}px; }";
    }

    $logo_h = get_option( 'graylc_logo_height' );
    if ( $logo_h ) {
        $css .= ".login h1 a { height: {$logo_h}px; }";
    }

    $input_h = get_option( 'graylc_input_height' );
    if ( $input_h ) {
        $css .= ".login form .input, .login input[type='text'], .login input[type='password'] { min-height: {$input_h}px; }";
    }

    $input_bw = get_option( 'graylc_input_border_width' );
    if ( $input_bw ) {
        $css .= ".login form .input, .login input[type='text'], .login input[type='password'] { border-width: {$input_bw}px; }";
    }

    $input_bc = get_option( 'graylc_input_border_color' );
    if ( $input_bc ) {
        $css .= ".login form .input, .login input[type='text'], .login input[type='password'] { border-color: {$input_bc}; }";
    }

    $btn_bg = get_option( 'graylc_button_bg_color' );
    if ( $btn_bg ) {
        $css .= "#login form p.submit input { background-color: {$btn_bg}; }";
    }

    $btn_color = get_option( 'graylc_button_text_color' );
    if ( $btn_color ) {
        $css .= "#login form p.submit input { color: {$btn_color}; }";
    }

    // Escape CSS late — right before sending it to WordPress
    if ( ! empty( $css ) ) {
        wp_add_inline_style( 'graylc-login', wp_strip_all_tags( $css ) );
    }
}

