<?php 


// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


add_action('admin_menu', 'graylc_add_menu_page');
function graylc_add_menu_page(){
    add_menu_page('Gray Login Customizer', 'Gray Login Customizer', 'manage_options', 'graylc-options', 'graylc_customizer_settings');
    
    // Main submenu (same as main page)
    add_submenu_page(
        'graylc-options',
        'Gray Login Customizer',
        'Gray Login Customizer',
        'manage_options',
        'graylc-options',
        'graylc_customizer_settings'
    );

    add_submenu_page(
        'graylc-options',
        'Customizer Settings',
        'Customizer Settings',
        'manage_options',
        'glc-customizer',
        ''  // empty callback, we will replace URL below
    );

}

// Replace the submenu page URL with the direct Customizer URL
add_action('admin_menu', function() {
    global $submenu;
    $customizer_url = admin_url('customize.php?autofocus[panel]=glc-panels');

    if ( isset($submenu['graylc-options']) ) {
        foreach ( $submenu['graylc-options'] as &$submenu_item ) {
            if ( $submenu_item[2] === 'glc-customizer' ) {
                $submenu_item[2] = $customizer_url;
            }
        }
    }


});


add_action( 'admin_init', 'graylc_register_settings' );
function graylc_register_settings() {

    register_setting( 'graylc_settings_group', 'graylc_logo_url_redirect', [
        'sanitize_callback' => 'esc_url_raw',
    ] );

    register_setting( 'graylc_settings_group', 'graylc_logo_text', [
        'sanitize_callback' => 'sanitize_text_field',
    ] );

    register_setting( 'graylc_settings_group', 'graylc_remember_me', [
        'sanitize_callback' => function ( $input ) {
            return wp_validate_boolean( $input ) ? 1 : 0;
        },
    ] );
}


function graylc_customizer_settings() {
    ?>
    <div class="wrap">
        <h2><?php esc_html_e('Gray Login Customizer Settings', 'gray-login-customizer'); ?></h2>

        <form action="options.php" method="post">
            <?php settings_fields('graylc_settings_group'); ?>

            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="graylc_logo_url_redirect"><?php esc_html_e('Logo URL Redirect', 'gray-login-customizer'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="graylc_logo_url_redirect" name="graylc_logo_url_redirect" value="<?php echo esc_attr(get_option('graylc_logo_url_redirect')); ?>" class="regular-text">
                        <p class="description"><?php esc_attr_e('Default Logo URL will go to homepage, unless changed.', 'gray-login-customizer');?></p>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="graylc_logo_text"><?php esc_html_e('Logo Text', 'gray-login-customizer'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="graylc_logo_text" name="graylc_logo_text" value="<?php echo esc_attr(get_option('graylc_logo_text')); ?>" class="regular-text">
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php esc_html_e('Remember Me', 'gray-login-customizer'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" name="graylc_remember_me" value="1" <?php checked(get_option('graylc_remember_me'), 1); ?>>
                            <?php esc_html_e('Enable "Remember Me" by default', 'gray-login-customizer'); ?>
                        </label>
                    </td>
                </tr>
            </table>

            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}



