<?php


// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$wp_customize->add_section('graylc_style_section', array(
    'title' => 'Login Page Style',
    'panel' => 'glc-panels',
));


/**
 * Logo Width
 */
$wp_customize->add_setting('graylc_form_width', array(
    'default' => '400',
    'sanitize_callback' => 'sanitize_text_field',
    'type' => 'option',
));
$wp_customize->add_control('graylc_form_width_control', array(
    'label' => __('Form Width (e.g. 400px)', 'gray-login-customizer'),
    'section' => 'graylc_style_section',
    'settings' => 'graylc_form_width',
    'type' => 'text',
));


/**
 * Logo Width
 */
$wp_customize->add_setting('graylc_logo_width', array(
    'default' => '150',
    'sanitize_callback' => 'sanitize_text_field',
    'type' => 'option',
));
$wp_customize->add_control('graylc_logo_width_control', array(
    'label' => __('Logo Width (e.g. 150px)', 'gray-login-customizer'),
    'section' => 'graylc_style_section',
    'settings' => 'graylc_logo_width',
    'type' => 'text',
));

/**
 * Logo Height
 */
$wp_customize->add_setting('graylc_logo_height', array(
    'default' => '50',
    'sanitize_callback' => 'sanitize_text_field',
    'type' => 'option',
));
$wp_customize->add_control('graylc_logo_height_control', array(
    'label' => __('Logo Height (e.g. 50px or auto)', 'gray-login-customizer'),
    'section' => 'graylc_style_section',
    'settings' => 'graylc_logo_height',
    'type' => 'text',
));

/**
 * Input Height
 */
$wp_customize->add_setting('graylc_input_height', array(
    'default' => '40',
    'sanitize_callback' => 'sanitize_text_field',
    'type' => 'option',
));
$wp_customize->add_control('graylc_input_height_control', array(
    'label' => __('Input Height (e.g. 45px)', 'gray-login-customizer'),
    'section' => 'graylc_style_section',
    'settings' => 'graylc_input_height',
    'type' => 'text',
));

/**
 * Input Border
 */
$wp_customize->add_setting('graylc_input_border_width', array(
    'default'           => '1',
    'sanitize_callback' => 'sanitize_text_field',
    'type'              => 'option',
));
$wp_customize->add_control('graylc_input_border_width_control', array(
    'label'    => __('Input Border Width (e.g. 1px)', 'gray-login-customizer'),
    'section'  => 'graylc_style_section',
    'settings' => 'graylc_input_border_width',
    'type'     => 'text',
));


/**
 * Input Border Color
 */
$wp_customize->add_setting('graylc_input_border_color', array(
    'default'           => '#cccccc',
    'sanitize_callback' => 'sanitize_hex_color',
    'type'              => 'option',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'graylc_input_border_color_control',
    array(
        'label'    => __('Input Border Color', 'gray-login-customizer'),
        'section'  => 'graylc_style_section',
        'settings' => 'graylc_input_border_color',
    )
));


/**
 * Button Background
 */
$wp_customize->add_setting('graylc_button_bg_color', array(
    'default' => '#0073aa',
    'sanitize_callback' => 'sanitize_hex_color',
    'type' => 'option',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'graylc_button_bg_color_control',
    array(
        'label' => __('Button Background Color', 'gray-login-customizer'),
        'section' => 'graylc_style_section',
        'settings' => 'graylc_button_bg_color',
    )
));

/**
 * Button Text Color
 */
$wp_customize->add_setting('graylc_button_text_color', array(
    'default' => '#ffffff',
    'sanitize_callback' => 'sanitize_hex_color',
    'type' => 'option',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'graylc_button_text_color_control',
    array(
        'label' => __('Button Text Color', 'gray-login-customizer'),
        'section' => 'graylc_style_section',
        'settings' => 'graylc_button_text_color',
    )
));
