<?php
/**
 * Plugin Name: Gray Login Customizer
 * Description: Gray Login Page Customizer for WordPress
 * Author: GrayWp
 * Author URI: https://profiles.wordpress.org/graywp/
 * Plugin URI: https://graywp.com
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Version: 1.0.5
 * Text Domain: gray-login-customizer
 * License: GPLv2 or later  
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html  
 * Tags: custom login customizer, gray login customize, login page customize, login customizer, login designer
 */


// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define Plugin Version
if ( ! defined( 'GRAYLC_VERSION' ) ) {
    define( 'GRAYLC_VERSION', '1.0.3' );
}

// Plugin Path
define('GRAYLC_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('GRAYLC_PLUGIN_URL', plugin_dir_url(__FILE__));

// Assets Enqueue
require_once GRAYLC_PLUGIN_PATH . 'inc/glc-front-assets.php';
// Admin settings
require_once GRAYLC_PLUGIN_PATH . 'inc/glc-admin-settings.php';
// Customizer settings
require_once GRAYLC_PLUGIN_PATH . 'inc/glc-customizer-settings.php';
// Option settings
require_once GRAYLC_PLUGIN_PATH . 'inc/glc-option-settings.php';


// Register Actication Hook
register_activation_hook(__FILE__, 'graylc_register_activation');
function graylc_register_activation(){
    update_option('graylc_plugin_redirect', true); // set flag
}


add_action('admin_init', 'graylc_redirect_function');
function graylc_redirect_function(){
    if (get_option('graylc_plugin_redirect')) {
        delete_option('graylc_plugin_redirect'); // remove flag
        wp_safe_redirect(admin_url('admin.php?page=graylc-options'));
        exit;
    }
};