jQuery(document).ready(function ($) {
    // Make the table rows sortable
    $("#sortable").sortable({
        handle: ".drag-handle",
        update: function () {
            var order = [];
            $("#sortable tr").each(function () {
                order.push($(this).data("id"));
            });

            // Send the new order to the server
            $.post(gravyware_quick_links_ajax.ajax_url, {
                action: "gravyware_quick_links_save_sort_order",
                order: order,
                nonce: gravyware_quick_links_ajax.nonce
            }).done(function (response) {
                if (response.success) {
                    console.log("Order updated successfully!");
                } else {
                    console.error("Failed to update order: ", response.data);
                }
            });
        }
    });
});

