<?php
/**
 * Classe gcSeoHelper
 *
 * Vérifie si un visiteur est un bot en analysant le User-Agent.
 */
if ( ! class_exists( 'GcSeoHelper' ) ) {
    class GcSeoHelper {

        /**
         * Vérifie si le visiteur est un bot.
         *
         * @return bool True si c'est un bot, false sinon.
         */
        public static function request_is_bot() {
            $seo_activated = get_option( 'gc_seo_activated' );

            if ( ! $seo_activated ) {
                return false;
            }

            if ( ! isset( $_SERVER['HTTP_USER_AGENT'] ) ) {
                return false;
            }

            $user_agent = strtolower( $_SERVER['HTTP_USER_AGENT'] );

            $bot_list = array(
                // Moteurs de recherche
                'googlebot',
                'bingbot',
                'slurp', // Yahoo
                'duckduckbot',
                'baiduspider',
                'yandexbot',
                'sogou',
                'exabot',
                'facebot',
                'ia_archiver',

                // Autres bots courants
                'mj12bot',
                'semrushbot',
                'ahrefsbot',
                'spbot',
                'dotbot',
                'robot',
                'crawler',
                'spider',
                'siteexplorer',
                'linkwalker',
                'mediapartners-google',

                // Bots mobiles
                'googlebot-mobile',
                'adsbot-google-mobile',

                // Bots sociaux
                'twitterbot',
                'facebookexternalhit',
                'linkedinbot',
                'pinterestbot',

                // Autres
                'petalbot',
                'applebot',
                'seznambot',
                'qwantify',
                'coccocbot',
                'yeti',
                'archive.org_bot',
                'telegrambot',
            );

            foreach ( $bot_list as $bot ) {
                if ( strpos( $user_agent, $bot ) !== false ) {
                    return true; // C'est un bot
                }
            }

            return false; // Ce n'est pas un bot
        }
    }
}
