<?php
/**
 * Classe responsable de la gestion asynchrone de l'importation des commentaires
 */

require_once __DIR__ . '/../services/gc_logger.class.php';
require_once __DIR__ . '/../../lib/WP_Async_Task.php';

if (!class_exists('GcImportComment')) {
    class GcImportComment extends WP_Async_Task {

        protected $action = 'import_comment';

        /**
         * Prépare les données pour la requête asynchrone
         *
         * @param array $data Un tableau de données envoyé au hook
         * @return array
         */
        protected function prepare_data($data) {
            $prepared_data = array(
                'gc_import_action' => $data,
            );
            return $prepared_data;
        }

        /**
         * Exécute l'action de la tâche asynchrone
         */
        protected function run_action() {
            if (isset($_POST['gc_import_action'])) {
                do_action("wp_async_$this->action", $_POST['gc_import_action']);
            } else {
                GcLogger::getLogger()->error('GcImportComment::run_action() - gc_import_action not set in $_POST');
            }
        }
    }
}

new GcImportComment();
