<?php

if ( ! class_exists( 'GcDateTools' ) ) {
    class GcDateTools {

        /**
         * Retourne la chaîne de fuseau horaire pour un site, même si un décalage UTC est défini.
         *
         * @return string Chaîne de fuseau horaire PHP valide ou décalage.
         */
        public static function wp_get_timezone_string() {
            $timezone = get_option( 'timezone_string' );

            if ( $timezone ) {
                return $timezone;
            }

            $gmt_offset = get_option( 'gmt_offset', 0 );

            // Construire une chaîne de décalage horaire comme '+02:00'
            $offset = (float) $gmt_offset;
            $hours = (int) $offset;
            $minutes = ( $offset - $hours ) * 60;
            $sign = $offset < 0 ? '-' : '+';
            $abs_hours = abs( $hours );
            $abs_minutes = abs( $minutes );
            $tz_offset = sprintf( '%s%02d:%02d', $sign, $abs_hours, $abs_minutes );

            return $tz_offset;
        }
    }
}
