<?php

require_once __DIR__ . '/../services/gc_params_service.class.php';
require_once __DIR__ . '/../templates/authorization.template.php';

/**
 * Classe GcAuthorization
 *
 * Gère l'autorisation OAuth pour GraphComment.
 */
if ( ! class_exists( 'GcAuthorization' ) ) {
    class GcAuthorization {

        /**
         * Vérifie si l'utilisateur est connecté via OAuth.
         * Si ce n'est pas le cas, affiche la popup d'autorisation OAuth.
         *
         * @return bool Retourne true si l'utilisateur est connecté, false sinon.
         */
        public static function checkOrPrintOauthIframe() {
            $params_service = GcParamsService::getInstance();

            $is_logged     = $params_service->graphcommentOAuthIsLogged();
            $token_renewed = $params_service->graphcommentRenewToken();

            if ( ! $is_logged && ! $token_renewed ) {
                // Initialise la connexion OAuth
                $params_service->graphcommentOAuthInitConnection();

                $oauth_client_key   = $params_service->graphcommentGetClientKey();
                $oauth_redirect_uri = $params_service->graphcommentGetRedirectUri();

                if ( ! empty( $oauth_client_key ) && ! empty( $oauth_redirect_uri ) ) {
                    // Affiche le template d'autorisation OAuth
                    GcAuthorizationTemplate::getTemplate();
                } else {
                    // Affiche le template d'erreur si les clés sont manquantes
                    GcAuthorizationTemplate::getErrorTemplate( $oauth_client_key, $oauth_redirect_uri );
                }
                return false;
            }

            return true;
        }
    }
}
