<?php

require_once('gc_abstract_controller.class.php');

/**
 * @controller GcGeneralController
 *
 * Gère l'onglet d'activation
 */

if ( ! class_exists( 'GcGeneralController' ) ) {
    class GcGeneralController extends GcController {

        public function handleOptionForm() {
            GcLogger::getLogger()->debug( 'GcGeneralController::handleOptionForm()' );

            // Initialisation
            $done = false;

            // Activation du plugin
            if ( isset( $this->post['gc_activated'] ) && $this->post['gc_activated'] === 'true' ) {
                GcParamsService::getInstance()->graphcommentActivate();
                update_option( 'gc-msg', json_encode( array( 'type' => 'success', 'content' => __( 'GraphComment Activated', 'graphcomment-comment-system' ), 'active_tab' => 'general' ) ) );
                $done = true;
                GcLogger::getLogger()->debug( 'GcGeneralController::handleOptionForm() - Activate' );
            }

            // Type d'activation
            if ( isset( $this->post['gc_activated_type'] ) ) {
                if ( $this->post['gc_activated_type'] === 'all' ) {
                    GcParamsService::getInstance()->graphcommentActivateAll();
                    update_option( 'gc-msg', json_encode( array( 'type' => 'success', 'content' => __( 'GraphComment Activated All', 'graphcomment-comment-system' ), 'active_tab' => 'general' ) ) );
                    $done = true;
                    GcLogger::getLogger()->debug( 'GcGeneralController::handleOptionForm() - Activate All' );
                } elseif ( $this->post['gc_activated_type'] === 'from' ) {
                    $activated_from = isset( $this->post['gc_activated_from'] ) ? sanitize_text_field( $this->post['gc_activated_from'] ) : '';
                    GcParamsService::getInstance()->graphcommentActivateFrom( $activated_from );
                    update_option( 'gc-msg', json_encode( array( 'type' => 'success', 'content' => sprintf( __( 'GraphComment Activated From %s.', 'graphcomment-comment-system' ), $activated_from ), 'active_tab' => 'general' ) ) );
                    $done = true;
                    GcLogger::getLogger()->debug( 'GcGeneralController::handleOptionForm() - Activate From (' . $activated_from . ')' );
                }
            }

            // Désactivation si aucune action n'a été effectuée
            if ( ! $done ) {
                GcParamsService::getInstance()->graphcommentDeactivate();
                update_option( 'gc-msg', json_encode( array( 'type' => 'warning', 'content' => __( 'GraphComment Deactivated', 'graphcomment-comment-system' ), 'active_tab' => 'general' ) ) );
                GcLogger::getLogger()->debug( 'GcGeneralController::handleOptionForm() - Deactivate' );
            }

            // Désactivation si 'gc_activated' n'est pas défini
            if ( ! isset( $this->post['gc_activated'] ) ) {
                GcParamsService::getInstance()->graphcommentDeactivate();

                // Désactiver la synchronisation
                update_option( 'gc_sync_comments', 'false' );
                delete_option( 'gc-sync-error' );
                wp_clear_scheduled_hook( 'graphcomment_cron_task_sync_comments_action' );
            }

            // Mise à jour des options SEO
            if ( isset( $this->post['gc_seo_activated'] ) ) {
                GcParamsService::getInstance()->graphcommentUpdateSEOFriendly( true );
            } else {
                GcParamsService::getInstance()->graphcommentUpdateSEOFriendly( false );
            }

            // Mise à jour des options SSO
            if ( isset( $this->post['gc_sso_activated'] ) ) {
                GcParamsService::getInstance()->graphcommentUpdateSSO( true );
            } else {
                GcParamsService::getInstance()->graphcommentUpdateSSO( false );
            }

            // Mise à jour des options Overlay
            if ( isset( $this->post['gc_overlay_activated'] ) ) {
                GcParamsService::getInstance()->graphcommentUpdateOverlay( true, array(
                    'overlay_visible'             => isset( $this->post['gc_overlay_visible'] ) ? sanitize_text_field( $this->post['gc_overlay_visible'] ) : '',
                    'overlay_bubble'              => isset( $this->post['gc_overlay_bubble'] ) ? sanitize_text_field( $this->post['gc_overlay_bubble'] ) : '',
                    'overlay_width'               => isset( $this->post['gc_overlay_width'] ) ? sanitize_text_field( $this->post['gc_overlay_width'] ) : '',
                    'overlay_fixed_header_height' => isset( $this->post['gc_overlay_fixed_header_height'] ) ? sanitize_text_field( $this->post['gc_overlay_fixed_header_height'] ) : '',
                    'overlay_button_label'        => isset( $this->post['gc_overlay_button_label'] ) ? sanitize_text_field( $this->post['gc_overlay_button_label'] ) : '',
                    'overlay_button_color'        => isset( $this->post['gc_overlay_button_color'] ) ? sanitize_text_field( $this->post['gc_overlay_button_color'] ) : '',
                    'overlay_button_background'   => isset( $this->post['gc_overlay_button_background'] ) ? sanitize_text_field( $this->post['gc_overlay_button_background'] ) : '',
                ) );
            } else {
                GcParamsService::getInstance()->graphcommentUpdateOverlay( false, array() );
            }

            // Mise à jour des options Readonly
            if ( isset( $this->post['gc_readonly_activated'] ) ) {
                GcParamsService::getInstance()->graphcommentUpdateReadonly( true, array(
                    'readonly_who'   => isset( $this->post['gc_readonly_who'] ) ? sanitize_text_field( $this->post['gc_readonly_who'] ) : '',
                    'readonly_roles' => isset( $this->post['gc_readonly_roles'] ) ? array_map( 'sanitize_text_field', (array) $this->post['gc_readonly_roles'] ) : array(),
                ) );
            } else {
                GcParamsService::getInstance()->graphcommentUpdateReadonly( false, array() );
            }

            // Redirection vers la page des paramètres
            wp_redirect( admin_url( 'admin.php?page=graphcomment-settings' ) );
            exit;
        }
    }
}
