<?php
/**
 * Fired when the GR UPN Payment Form plugin is uninstalled.
 *
 * @package GrUpnPf
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * -----------------------------------------
 * DELETE PLUGIN OPTIONS
 * -----------------------------------------
 */
$grupnpf_options_to_delete = [
    'grupnpf_ime_prejemnika',
    'grupnpf_ulica_prejemnika',
    'grupnpf_posta_prejemnika',
    'grupnpf_kraj_prejemnika',
    'grupnpf_iban_prejemnika',
    'grupnpf_koda_namena',
    'grupnpf_referenca_prejemnika',
    'grupnpf_namen_placila',
    'grupnpf_email_vstavi_upn',
    'grupnpf_email_priponka',
    'grupnpf_predpona_upn_slike',
    'grupnpf_thankyou_page',
    'grupnpf_perform_full_uninstall',
    'grupnpf_enable_debug_logging',
];

foreach ($grupnpf_options_to_delete as $grupnpf_option_key) {
    delete_option($grupnpf_option_key);
}

/**
 * -----------------------------------------
 * INITIALIZE FILESYSTEM
 * -----------------------------------------
 */
if (!function_exists('WP_Filesystem')) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
}

WP_Filesystem();
global $wp_filesystem;

/**
 * -----------------------------------------
 * DELETE QR CODE DIRECTORY
 * -----------------------------------------
 */
$grupnpf_upload_dir = wp_upload_dir();
$grupnpf_qr_dir = trailingslashit($grupnpf_upload_dir['basedir']) . 'grupnpf-qrcodes';

if ($wp_filesystem && $wp_filesystem->is_dir($grupnpf_qr_dir)) {
    $wp_filesystem->rmdir($grupnpf_qr_dir, true); // recursive delete
}

/**
 * -----------------------------------------
 * REMOVE CRON JOBS
 * -----------------------------------------
 */
wp_clear_scheduled_hook('grupnpf_daily_cleanup');