document.addEventListener('DOMContentLoaded', function () {
    var ibanInput = document.getElementById('grupnpf_iban_prejemnika');

    if (ibanInput) {
        ibanInput.addEventListener('input', function (e) {
            var target = e.target;
            var value = target.value.replace(/\s/g, '').toUpperCase();

            if (value.length > 19) {
                value = value.substring(0, 19);
            }

            var formattedValue = '';
            for (var i = 0; i < value.length; i++) {
                if (i > 0 && i % 4 === 0) {
                    formattedValue += ' ';
                }
                formattedValue += value[i];
            }

            target.value = formattedValue;
        });
    }
});
