<?php
namespace GrUpnPf;

if (!defined('ABSPATH'))
    exit;

class GrUpnPf_Logic_UPN
{
    public static $upn_email_displayed = false;
    public static $upn_thankyou_displayed = false;

    public function __construct()
    {
    }

    /**
     * Generate PNG binary of UPN code
     */
    public function genUPN($order)
    {
        grupnpf_log('FREE: genUPN - Starting UPN generation for order ' . $order->get_id());

        $required_options = [
            "grupnpf_ime_prejemnika",
            "grupnpf_ulica_prejemnika",
            "grupnpf_posta_prejemnika",
            "grupnpf_kraj_prejemnika",
            "grupnpf_iban_prejemnika",
            "grupnpf_koda_namena",
            "grupnpf_referenca_prejemnika",
            "grupnpf_namen_placila",
        ];

        foreach ($required_options as $option) {
            if (empty(get_option($option))) {
                grupnpf_log("FREE: genUPN - Failed: Required option '{$option}' is empty.");
                return null;
            }
        }

        // Build UPN PNG binary
        $png = (new GrUpnPf_UPN())
            ->setPayerName($order->get_formatted_billing_full_name())
            ->setPayerAddress($order->get_billing_address_1())
            ->setPayerPost(sprintf(
                "%s %s",
                $order->get_billing_postcode(),
                $order->get_billing_city()
            ))
            ->setReceiverName(get_option("grupnpf_ime_prejemnika"))
            ->setReceiverAddress(get_option("grupnpf_ulica_prejemnika"))
            ->setReceiverPost(sprintf(
                "%s %s",
                get_option("grupnpf_posta_prejemnika"),
                get_option("grupnpf_kraj_prejemnika")
            ))
            ->setReceiverIban(get_option("grupnpf_iban_prejemnika"))
            ->setAmount($order->get_total())
            ->setCode(get_option("grupnpf_koda_namena"))
            ->setReference(sprintf(
                "%s %s",
                get_option("grupnpf_referenca_prejemnika"),
                $order->get_order_number()
            ))
            ->setDueDate(new \DateTime($order->get_date_created()))
            ->setPurpose(sprintf(
                "%s %s",
                get_option("grupnpf_namen_placila", "Plačilo naročila"),
                $order->get_order_number()
            ))
            ->png();

        return (!empty($png) ? $png : null);
    }


    /**
     * Save PNG binary to uploads folder and return filesystem path.
     * URL is also stored separately for frontend use.
     */
    public function saveUpnImage($png, $order_id)
    {
        $upload_dir = wp_upload_dir();

        // Path + URL structure
        $dir = trailingslashit($upload_dir['basedir']) . 'grupnpf-qrcodes/';
        $url = trailingslashit($upload_dir['baseurl']) . 'grupnpf-qrcodes/';

        if (!file_exists($dir)) {
            wp_mkdir_p($dir);
        }

        $prefix = sanitize_file_name(
            get_option('grupnpf_predpona_upn_slike', 'qr-upn')
        );

        $filename = $prefix . '-' . $order_id . '.png';

        // Filesystem path (important for file_exists(), email attachments, CID embedding)
        $filepath = $dir . $filename;

        // URL for frontend rendering only (NOT used by file_exists)
        $fileurl = $url . $filename;

        grupnpf_log("FREE: saveUpnImage - Saving image to filesystem path: {$filepath}");

        file_put_contents($filepath, $png);

        grupnpf_log("FREE: saveUpnImage - Successfully saved image to: {$filepath}");

        // Store the URL separately (safe)
        update_post_meta($order_id, '_grupnpf_upn_url', $fileurl);
        update_post_meta($order_id, '_grupnpf_upn_path', $filepath);

        // Return absolute filesystem path only
        return $filepath;
    }
}