<?php
/**
 * Plugin Name: GR UPN payment form
 * Description: Generates UPN payment forms (Slovenian) with QR codes for customers.
 * Version: 1.4.3
 * Author: Grega78
 * Author URI: https://gregarednak.si
 * Text Domain: gr-upn-payment-form
 * Domain Path: /languages
 * Tested up to: 6.8
 * Stable tag: 1.4.3
 * Requires PHP: 8.2
 * Tags: woocommerce, qr, upn, slovenia, bacs
 * License: GPL-3.0
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 */

/*
GR UPN payment form
Copyright (C) 2024 Grega Rednak

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
namespace GrUpnPf;

/**
 * Global logging function for the plugin.
 *
 * @param string $message The message to log.
 */
function grupnpf_log($message)
{
    if (get_option('grupnpf_enable_debug_logging') === 'yes' && defined('WP_DEBUG_LOG') && WP_DEBUG_LOG) {
        if (is_array($message) || is_object($message)) {
            $message = print_r($message, true);
        }
        error_log('[GR UPN DEBUG] ' . $message);
    }
}

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

if (!defined('GRUPNPF_PLUGIN_FILE')) {
    define('GRUPNPF_PLUGIN_FILE', __FILE__);
}

require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';

if (class_exists('GrUpnPf\GrUpnPf_Main')) {
    new GrUpnPf_Main();
}