<?php
/**
 * Plugin Name: GPTrends Agent Analytics
 * Plugin URI: https://docs.gptrends.io/agent-analytics
 * Description: GPTrends helps companies understand how AI agents and bots crawl, reference, and interact with their content — turning AI visibility optimization from a black box into data-driven actions.
 * Version: 1.0.4
 * Requires at least: 5.0
 * Requires PHP: 7.0
 * Author: GPTrends
 * Author URI: https://gptrends.io
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: gptrends-agent-analytics
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'GPTRENDS_VERSION', '1.0.4' );
define( 'GPTRENDS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GPTRENDS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'GPTRENDS_PLUGIN_FILE', __FILE__ );

require_once GPTRENDS_PLUGIN_DIR . 'includes/class-gptrends-tracker.php';
require_once GPTRENDS_PLUGIN_DIR . 'includes/class-gptrends-admin.php';

function gptrends_init() {
    new GPTrends_Tracker();

    if ( is_admin() ) {
        new GPTrends_Admin();
    }
}
add_action( 'plugins_loaded', 'gptrends_init' );

function gptrends_activate() {
    if ( ! get_option( 'gptrends_options' ) ) {
        add_option( 'gptrends_options', array(
            'enabled' => true,
            'website_key' => '',
            'api_endpoint' => '',
        ) );
    }
}
register_activation_hook( __FILE__, 'gptrends_activate' );

function gptrends_deactivate() {}
register_deactivation_hook( __FILE__, 'gptrends_deactivate' );
