<?php
// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/classes/dashboard/class-aipkit_ai_settings.php
// REVISED FILE - Moved AJAX handlers to separate classes
// UPDATED: Removed 'buffer' from default AI params and saving logic.

namespace WPAICG;

use WPAICG\Core\Providers\Google\GoogleSettingsHandler;
use WP_Error;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class to handle AI Settings definitions, initialization, and retrieval.
 * AJAX saving and model sync logic has been moved to dedicated handler classes.
 */
if (!class_exists('\\WPAICG\\AIPKIT_AI_Settings')) {
    class AIPKIT_AI_Settings {

        // Default advanced parameters for AI generation.
        public static $default_ai_params = array(
            'temperature' => 1.0,
            'top_p' => 1.0,
            'frequency_penalty' => 0.0,
            'presence_penalty' => 0.0,
        );

        // Default API Keys structure.
        // Moved to public static.
        public static $default_api_keys = array(
            'public_api_key' => '',
        );

        /**
         * Initializes settings checks.
         * AJAX hooks are now registered in DashboardInitializer.
         */
        public static function init() {
            // Ensure Google Settings Handler is loaded
            $google_settings_handler_path = WPAICG_PLUGIN_DIR . 'classes/core/providers/google/GoogleSettingsHandler.php';
            if (!class_exists(GoogleSettingsHandler::class) && file_exists($google_settings_handler_path)) {
                 require_once $google_settings_handler_path;
            }

            // Initialize Google safety settings via the handler if available
            if (class_exists(GoogleSettingsHandler::class) && method_exists(GoogleSettingsHandler::class, 'check_and_init_safety_settings')) {
                GoogleSettingsHandler::check_and_init_safety_settings();
            }
            // Initialize core settings
            self::check_and_init_ai_parameters();
            self::check_and_init_api_keys();
        }

        /** Ensure ai_parameters exist in the options array. */
        private static function check_and_init_ai_parameters() {
            $opts = get_option('aipkit_options', array());
            if (!isset($opts['ai_parameters']) || !is_array($opts['ai_parameters'])) {
                $opts['ai_parameters'] = self::$default_ai_params;
                update_option('aipkit_options', $opts, 'no');
            } else {
                // Ensure all default keys exist and remove obsolete ones
                $final_params = [];
                foreach (self::$default_ai_params as $key => $default_value) {
                    $final_params[$key] = $opts['ai_parameters'][$key] ?? $default_value;
                }
                if ($final_params !== $opts['ai_parameters']) {
                    $opts['ai_parameters'] = $final_params;
                    update_option('aipkit_options', $opts, 'no');
                }
            }
        }

        /** Ensure api_keys exist in the options array. */
        private static function check_and_init_api_keys() {
             $opts = get_option('aipkit_options', array());
             if (!isset($opts['api_keys']) || !is_array($opts['api_keys'])) {
                 $opts['api_keys'] = self::$default_api_keys;
                 update_option('aipkit_options', $opts, 'no');
             } else {
                 $merged = array_merge(self::$default_api_keys, $opts['api_keys']);
                 if ($merged !== $opts['api_keys']) {
                     $opts['api_keys'] = $merged;
                     update_option('aipkit_options', $opts, 'no');
                 }
             }
        }

        /** Retrieve advanced AI parameters. */
        public static function get_ai_parameters(): array {
            $opts = get_option('aipkit_options', array());
            self::check_and_init_ai_parameters(); // Ensure initialized
            $opts = get_option('aipkit_options', array()); // Re-fetch
            return $opts['ai_parameters'] ?? self::$default_ai_params;
        }

        /** Retrieve API Keys. */
        public static function get_api_keys(): array {
             $opts = get_option('aipkit_options', array());
             self::check_and_init_api_keys(); // Ensure initialized
             $opts = get_option('aipkit_options', array()); // Re-fetch
             return $opts['api_keys'] ?? self::$default_api_keys;
        }

    } // End class

    AIPKIT_AI_Settings::init();
}
