<?php
// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/admin/views/modules/settings/partials/settings-advanced-integrations.php
// Status: MODIFIED
// I have removed the direct includes for Pinecone and Qdrant as their settings are now in the combined vector-databases.php partial.

/**
 * Partial: Integrations Settings
 * This file acts as a router, including different integration partials.
 */
if (!defined('ABSPATH')) {
    exit;
}

use WPAICG\AIPKit_Providers;

// Variables passed from parent (settings/index.php) are used by the included partials.

// Prepare variables needed by the included partials
$current_pinecone_api_key = $pinecone_data['api_key'] ?? '';
$current_pinecone_default_index = $pinecone_data['default_index'] ?? '';
$pinecone_index_list = AIPKit_Providers::get_pinecone_indexes();


$current_qdrant_api_key = $qdrant_data['api_key'] ?? '';
$current_qdrant_url = $qdrant_data['url'] ?? '';
$current_qdrant_default_collection = $qdrant_data['default_collection'] ?? '';
$qdrant_collection_list = AIPKit_Providers::get_qdrant_collections(); // Add this line for the new partial
$qdrant_defaults = AIPKit_Providers::get_provider_defaults('Qdrant'); // Add this line for the new partial


$replicate_data = AIPKit_Providers::get_provider_data('Replicate');
$current_replicate_api_key = $replicate_data['api_key'] ?? '';

$aipkit_options = get_option('aipkit_options', []);
$enhancer_editor_integration_enabled = $aipkit_options['enhancer_settings']['editor_integration'] ?? '1';
$enhancer_default_insert_position = $aipkit_options['enhancer_settings']['default_insert_position'] ?? 'replace';

?>
<div class="aipkit_settings-tab-content-inner-padding">
    <div class="aipkit_accordion-group">

        <?php include __DIR__ . '/integrations/rest-api.php'; ?>

        <?php include __DIR__ . '/integrations/ai-assistant.php'; ?>

        <?php include __DIR__ . '/integrations/semantic-search.php'; ?>

        <?php include __DIR__ . '/integrations/replicate.php'; ?>

        <?php include __DIR__ . '/integrations/vector-databases.php'; ?>

    </div>
</div>
