<?php
// File: admin/views/modules/content-writer/partials/source-selector.php
// Status: NEW FILE
/**
 * Partial: Content Writer - Source Selector
 * Dropdown for selecting content source (Manual Entry, CSV, RSS, URL, Google Sheets).
 * Moved to topbar to group with template selection (chunking principle).
 */

if (!defined('ABSPATH')) {
    exit;
}

$has_woocommerce = class_exists('WooCommerce') && post_type_exists('product');
?>
<div class="aipkit_cw_source_selector_wrapper">
    <div class="aipkit_cw_source_selector" data-aipkit-source-selector>
        <button
            type="button"
            class="aipkit_cw_source_trigger"
            aria-haspopup="listbox"
            aria-expanded="false"
            aria-controls="aipkit_cw_source_menu"
            data-aipkit-source-trigger
        >
            <span class="aipkit_cw_source_icon" data-source-icon="task" aria-hidden="true">
                <span class="dashicons dashicons-edit"></span>
            </span>
            <span class="aipkit_cw_source_label" data-source-label><?php esc_html_e('Manual Entry', 'gpt3-ai-content-generator'); ?></span>
            <span class="dashicons dashicons-arrow-down-alt2 aipkit_cw_source_arrow" aria-hidden="true"></span>
        </button>
        <ul
            id="aipkit_cw_source_menu"
            class="aipkit_cw_source_menu"
            role="listbox"
            aria-label="<?php esc_attr_e('Select content source', 'gpt3-ai-content-generator'); ?>"
            hidden
        >
            <li class="aipkit_cw_source_group" role="presentation" aria-hidden="true">
                <span class="aipkit_cw_source_group_label"><?php esc_html_e('Create new', 'gpt3-ai-content-generator'); ?></span>
            </li>
            <li class="aipkit_cw_source_option is-active" role="option" data-source="task" aria-selected="true">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-edit" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('Manual Entry', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Type topics directly', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <li class="aipkit_cw_source_option" role="option" data-source="csv" aria-selected="false">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-media-spreadsheet" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('Import CSV', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Upload a CSV file', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <li class="aipkit_cw_source_option" role="option" data-source="rss" aria-selected="false">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-rss" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('RSS Feed', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Pull from feed URL', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <li class="aipkit_cw_source_option" role="option" data-source="url" aria-selected="false">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-admin-links" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('Website URL', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Extract page content', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <li class="aipkit_cw_source_option" role="option" data-source="gsheets" aria-selected="false">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-analytics" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('Google Sheets', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Sync from spreadsheet', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <li class="aipkit_cw_source_group" role="presentation" aria-hidden="true">
                <span class="aipkit_cw_source_group_label"><?php esc_html_e('Update existing', 'gpt3-ai-content-generator'); ?></span>
            </li>
            <li class="aipkit_cw_source_option" role="option" data-source="existing-content" aria-selected="false">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-update" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('Update Content', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Rewrite titles and copy', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <li class="aipkit_cw_source_option" role="option" data-source="existing-images" aria-selected="false">
                <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-format-image" aria-hidden="true"></span></span>
                <span class="aipkit_cw_source_option_text">
                    <span class="aipkit_cw_source_option_title"><?php esc_html_e('Optimize Images', 'gpt3-ai-content-generator'); ?></span>
                    <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Alt text, title, caption', 'gpt3-ai-content-generator'); ?></span>
                </span>
                <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
            </li>
            <?php if ($has_woocommerce): ?>
                <li class="aipkit_cw_source_option" role="option" data-source="existing-products" aria-selected="false">
                    <span class="aipkit_cw_source_option_icon"><span class="dashicons dashicons-cart" aria-hidden="true"></span></span>
                    <span class="aipkit_cw_source_option_text">
                        <span class="aipkit_cw_source_option_title"><?php esc_html_e('Optimize Products', 'gpt3-ai-content-generator'); ?></span>
                        <span class="aipkit_cw_source_option_desc"><?php esc_html_e('Improve product copy', 'gpt3-ai-content-generator'); ?></span>
                    </span>
                    <span class="aipkit_cw_source_check dashicons dashicons-yes" aria-hidden="true"></span>
                </li>
            <?php endif; ?>
        </ul>
    </div>
    <label class="screen-reader-text" for="aipkit_cw_mode_select"><?php esc_html_e('Source', 'gpt3-ai-content-generator'); ?></label>
    <select id="aipkit_cw_mode_select" name="cw_generation_mode" class="aipkit_form-input aipkit_autosave_trigger screen-reader-text">
        <option value="task"><?php esc_html_e('Manual Entry', 'gpt3-ai-content-generator'); ?></option>
        <option value="csv"><?php esc_html_e('Import CSV', 'gpt3-ai-content-generator'); ?></option>
        <option value="rss"><?php esc_html_e('RSS Feed', 'gpt3-ai-content-generator'); ?></option>
        <option value="url"><?php esc_html_e('Website URL', 'gpt3-ai-content-generator'); ?></option>
        <option value="gsheets"><?php esc_html_e('Google Sheets', 'gpt3-ai-content-generator'); ?></option>
        <option value="existing-content"><?php esc_html_e('Update Content', 'gpt3-ai-content-generator'); ?></option>
        <option value="existing-images"><?php esc_html_e('Optimize Images', 'gpt3-ai-content-generator'); ?></option>
        <?php if ($has_woocommerce): ?>
            <option value="existing-products"><?php esc_html_e('Optimize Products', 'gpt3-ai-content-generator'); ?></option>
        <?php endif; ?>
        <option value="existing"><?php esc_html_e('Update Existing (Legacy)', 'gpt3-ai-content-generator'); ?></option>
    </select>
</div>
