<?php
// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/admin/views/modules/content-writer/partials/form-inputs.php
// Status: MODIFIED
/**
 * Partial: Content Writer Form Inputs
 * Redesigned with three core UX principles:
 * 1. Aesthetic - Clean, consistent visual design
 * 2. Choice Overload - Reduce overwhelm by showing focused, manageable groups
 * 3. Chunking - Group related settings visually for better comprehension
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load shared variables used by the partials
require_once __DIR__ . '/form-inputs/loader-vars.php';

?>
<!-- Quick Settings - Refined Cards with Visual Hierarchy -->
<div class="aipkit_cw_quick_settings">
    <!-- Primary Setting: AI Model -->
    <button
        type="button"
        class="aipkit_cw_setting_chip aipkit_cw_popover_trigger"
        data-aipkit-popover-target="aipkit_cw_ai_settings_popover"
        data-aipkit-popover-placement="left"
        aria-controls="aipkit_cw_ai_settings_popover"
        aria-expanded="false"
    >
        <span class="aipkit_cw_setting_chip_icon aipkit_cw_setting_chip_icon--primary">
            <span class="dashicons dashicons-superhero" aria-hidden="true"></span>
        </span>
        <span class="aipkit_cw_setting_chip_content">
            <span class="aipkit_cw_setting_chip_label"><?php esc_html_e('Model', 'gpt3-ai-content-generator'); ?></span>
            <span class="aipkit_cw_setting_chip_value" data-aipkit-cw-summary="ai" data-aipkit-placeholder="<?php esc_attr_e('Select', 'gpt3-ai-content-generator'); ?>">
                <?php esc_html_e('Select', 'gpt3-ai-content-generator'); ?>
            </span>
        </span>
    </button>
    
    <!-- Images -->
    <button
        type="button"
        class="aipkit_cw_setting_chip aipkit_cw_popover_trigger"
        data-aipkit-popover-target="aipkit_cw_image_settings_popover"
        data-aipkit-popover-placement="left"
        aria-controls="aipkit_cw_image_settings_popover"
        aria-expanded="false"
    >
        <span class="aipkit_cw_setting_chip_icon aipkit_cw_setting_chip_icon--images">
            <span class="dashicons dashicons-format-image" aria-hidden="true"></span>
        </span>
        <span class="aipkit_cw_setting_chip_content">
            <span class="aipkit_cw_setting_chip_label"><?php esc_html_e('Images', 'gpt3-ai-content-generator'); ?></span>
            <span class="aipkit_cw_setting_chip_value" data-aipkit-cw-summary="images" data-aipkit-placeholder="<?php esc_attr_e('Off', 'gpt3-ai-content-generator'); ?>" data-aipkit-disabled-label="<?php esc_attr_e('Off', 'gpt3-ai-content-generator'); ?>">
                <?php esc_html_e('Off', 'gpt3-ai-content-generator'); ?>
            </span>
        </span>
    </button>
    
    <!-- Knowledge Base -->
    <button
        type="button"
        class="aipkit_cw_setting_chip aipkit_cw_popover_trigger"
        data-aipkit-popover-target="aipkit_cw_vector_settings_popover"
        data-aipkit-popover-placement="left"
        aria-controls="aipkit_cw_vector_settings_popover"
        aria-expanded="false"
    >
        <span class="aipkit_cw_setting_chip_icon aipkit_cw_setting_chip_icon--vector">
            <span class="dashicons dashicons-database" aria-hidden="true"></span>
        </span>
        <span class="aipkit_cw_setting_chip_content">
            <span class="aipkit_cw_setting_chip_label"><?php esc_html_e('Knowledge Base', 'gpt3-ai-content-generator'); ?></span>
            <span class="aipkit_cw_setting_chip_value" data-aipkit-cw-summary="vector" data-aipkit-placeholder="<?php esc_attr_e('Off', 'gpt3-ai-content-generator'); ?>" data-aipkit-disabled-label="<?php esc_attr_e('Off', 'gpt3-ai-content-generator'); ?>">
                <?php esc_html_e('Off', 'gpt3-ai-content-generator'); ?>
            </span>
        </span>
    </button>
    
    <!-- Prompts (Featured - Primary Action) -->
    <button
        type="button"
        class="aipkit_cw_setting_chip aipkit_cw_setting_chip--featured aipkit_cw_popover_trigger"
        data-aipkit-popover-target="aipkit_cw_prompts_popover"
        data-aipkit-popover-placement="left"
        aria-controls="aipkit_cw_prompts_popover"
        aria-expanded="false"
    >
        <span class="aipkit_cw_setting_chip_icon aipkit_cw_setting_chip_icon--prompts">
            <span class="dashicons dashicons-edit-large" aria-hidden="true"></span>
        </span>
        <span class="aipkit_cw_setting_chip_content">
            <span class="aipkit_cw_setting_chip_label"><?php esc_html_e('Prompts', 'gpt3-ai-content-generator'); ?></span>
            <span class="aipkit_cw_setting_chip_value" data-aipkit-cw-summary="prompts" data-aipkit-placeholder="<?php esc_attr_e('Customize', 'gpt3-ai-content-generator'); ?>">
                <?php esc_html_e('Customize', 'gpt3-ai-content-generator'); ?>
            </span>
        </span>
    </button>
</div>

<div class="aipkit_model_settings_popover aipkit_cw_settings_popover" id="aipkit_cw_ai_settings_popover" aria-hidden="true">
    <div class="aipkit_model_settings_popover_panel aipkit_cw_settings_popover_panel" role="dialog" aria-label="<?php esc_attr_e('AI Settings', 'gpt3-ai-content-generator'); ?>">
        <div class="aipkit_model_settings_popover_body aipkit_cw_settings_popover_body">
            <?php include __DIR__ . '/form-inputs/ai-settings.php'; ?>
        </div>
    </div>
</div>

<div class="aipkit_model_settings_popover aipkit_cw_settings_popover" id="aipkit_cw_image_settings_popover" aria-hidden="true">
    <div class="aipkit_model_settings_popover_panel aipkit_cw_settings_popover_panel" role="dialog" aria-label="<?php esc_attr_e('Image Settings', 'gpt3-ai-content-generator'); ?>">
        <div class="aipkit_model_settings_popover_body aipkit_cw_settings_popover_body">
            <?php include __DIR__ . '/form-inputs/image-settings.php'; ?>
        </div>
    </div>
</div>

<div class="aipkit_model_settings_popover aipkit_cw_settings_popover" id="aipkit_cw_vector_settings_popover" aria-hidden="true">
    <div class="aipkit_model_settings_popover_panel aipkit_cw_settings_popover_panel aipkit_model_settings_popover_panel--allow-overflow" role="dialog" aria-label="<?php esc_attr_e('Knowledge Base', 'gpt3-ai-content-generator'); ?>">
        <div class="aipkit_model_settings_popover_body aipkit_cw_settings_popover_body">
            <?php include __DIR__ . '/form-inputs/vector-settings.php'; ?>
        </div>
    </div>
</div>

<!-- Prompts Popover - Redesigned with Chunking Principles -->
<div class="aipkit_model_settings_popover aipkit_cw_settings_popover" id="aipkit_cw_prompts_popover" aria-hidden="true">
    <div class="aipkit_model_settings_popover_panel aipkit_model_settings_popover_panel--allow-overflow aipkit_cw_settings_popover_panel aipkit_cw_prompts_panel" role="dialog" aria-label="<?php esc_attr_e('Prompts', 'gpt3-ai-content-generator'); ?>">
        <div class="aipkit_model_settings_popover_body aipkit_cw_settings_popover_body aipkit_cw_prompts_body">
            <?php include __DIR__ . '/form-inputs/prompts-settings.php'; ?>
        </div>
    </div>
</div>

<!-- Post Settings Popover - Focused on publishing options -->
<div class="aipkit_model_settings_popover aipkit_cw_settings_popover" id="aipkit_cw_post_settings_popover" aria-hidden="true">
    <div class="aipkit_model_settings_popover_panel aipkit_model_settings_popover_panel--allow-overflow aipkit_cw_settings_popover_panel" role="dialog" aria-label="<?php esc_attr_e('Post Settings', 'gpt3-ai-content-generator'); ?>">
        <div class="aipkit_model_settings_popover_body aipkit_cw_settings_popover_body">
            <?php include __DIR__ . '/form-inputs/post-settings.php'; ?>
        </div>
    </div>
</div>
</div>
