<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="aipkit_popover_options_list aipkit_popover_options_list--audio">
    <div class="aipkit_popover_option_group">
        <div class="aipkit_popover_option_row aipkit_popover_option_row--section">
            <div class="aipkit_popover_option_main">
                <span class="aipkit_popover_option_section_title">
                    <?php esc_html_e('Speech to text', 'gpt3-ai-content-generator'); ?>
                </span>
            </div>
        </div>
        <div class="aipkit_popover_option_row">
            <div class="aipkit_popover_option_main">
                <label
                    class="aipkit_popover_option_label"
                    for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_enable_voice_input_sheet"
                    data-tooltip="<?php echo esc_attr__('Speak to the bot using your mic.', 'gpt3-ai-content-generator'); ?>"
                >
                    <?php esc_html_e('Enabled', 'gpt3-ai-content-generator'); ?>
                </label>
                <div class="aipkit_popover_option_actions">
                    <label class="aipkit_switch">
                        <input
                            type="checkbox"
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_enable_voice_input_sheet"
                            name="enable_voice_input"
                            class="aipkit_voice_input_toggle_switch"
                            value="1"
                            <?php checked($enable_voice_input, '1'); ?>
                        />
                        <span class="aipkit_switch_slider"></span>
                    </label>
                </div>
            </div>
        </div>
        <div class="aipkit_popover_option_row aipkit_stt_provider_row" style="display: <?php echo $enable_voice_input === '1' ? 'block' : 'none'; ?>;">
            <div class="aipkit_popover_option_main">
                <span class="aipkit_popover_option_label">
                    <?php esc_html_e('Provider', 'gpt3-ai-content-generator'); ?>
                </span>
                <div class="aipkit_popover_inline_controls aipkit_stt_provider_conditional_row" style="display: <?php echo $enable_voice_input === '1' ? 'flex' : 'none'; ?>;">
                    <div class="aipkit_popover_inline_select">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_stt_provider_sheet"
                            name="stt_provider"
                            class="aipkit_popover_option_select aipkit_popover_option_select--compact aipkit_stt_provider_select"
                            aria-label="<?php esc_attr_e('Provider', 'gpt3-ai-content-generator'); ?>"
                        >
                            <option value="OpenAI" <?php selected($stt_provider, 'OpenAI'); ?>><?php esc_html_e('OpenAI', 'gpt3-ai-content-generator'); ?></option>
                        </select>
                    </div>
                    <div class="aipkit_popover_inline_select aipkit_stt_model_field" data-stt-provider="OpenAI" style="display: <?php echo $stt_provider === 'OpenAI' ? 'block' : 'none'; ?>;">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_stt_openai_model_id_sheet"
                            name="stt_openai_model_id"
                            class="aipkit_popover_option_select aipkit_popover_option_select--compact"
                            aria-label="<?php esc_attr_e('Model', 'gpt3-ai-content-generator'); ?>"
                        >
                            <?php
                            $found_current_stt = false;
                            if (!empty($openai_stt_models)) {
                                foreach ($openai_stt_models as $model) {
                                    $model_id_val = $model['id'] ?? '';
                                    $model_name_val = $model['name'] ?? $model_id_val;
                                    if ($model_id_val === $stt_openai_model_id) {
                                        $found_current_stt = true;
                                    }
                                    echo '<option value="' . esc_attr($model_id_val) . '" ' . selected($stt_openai_model_id, $model_id_val, false) . '>' . esc_html($model_name_val) . '</option>';
                                }
                            }
                            if (!$found_current_stt && !empty($stt_openai_model_id)) {
                                echo '<option value="' . esc_attr($stt_openai_model_id) . '" selected>' . esc_html($stt_openai_model_id) . ' (Manual/Not Synced)</option>';
                            } elseif (empty($openai_stt_models) && empty($stt_openai_model_id)) {
                                echo '<option value="whisper-1" selected>whisper-1 (Default)</option>';
                            }
                            ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="aipkit_popover_option_group">
            <div class="aipkit_popover_option_row aipkit_popover_option_row--section">
                <div class="aipkit_popover_option_main">
                    <span class="aipkit_popover_option_section_title">
                        <?php esc_html_e('Text to speech', 'gpt3-ai-content-generator'); ?>
                    </span>
                </div>
            </div>
            <div class="aipkit_popover_option_row">
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_enabled_sheet"
                        data-tooltip="<?php echo esc_attr__('Enable text to speech for bot responses.', 'gpt3-ai-content-generator'); ?>"
                    >
                        <?php esc_html_e('Enabled', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_option_actions">
                        <label class="aipkit_switch">
                            <input
                                type="checkbox"
                                id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_enabled_sheet"
                                name="tts_enabled"
                                class="aipkit_tts_toggle_switch"
                                value="1"
                                <?php checked($tts_enabled, '1'); ?>
                            />
                            <span class="aipkit_switch_slider"></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="aipkit_popover_option_row aipkit_tts_provider_row" style="display: <?php echo $tts_enabled === '1' ? 'block' : 'none'; ?>;">
                <div class="aipkit_popover_option_main">
                    <span class="aipkit_popover_option_label">
                        <?php esc_html_e('Provider', 'gpt3-ai-content-generator'); ?>
                    </span>
                    <div class="aipkit_popover_inline_controls aipkit_tts_conditional_settings" style="display: <?php echo $tts_enabled === '1' ? 'flex' : 'none'; ?>;">
                        <div class="aipkit_popover_inline_select">
                            <select
                                id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_provider_sheet"
                                name="tts_provider"
                                class="aipkit_popover_option_select aipkit_popover_option_select--compact aipkit_tts_provider_select"
                                aria-label="<?php esc_attr_e('TTS provider', 'gpt3-ai-content-generator'); ?>"
                            >
                                <?php foreach ($tts_providers as $provider_name): ?>
                                    <option value="<?php echo esc_attr($provider_name); ?>" <?php selected($tts_provider, $provider_name); ?>><?php echo esc_html($provider_name); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div
                class="aipkit_popover_option_row aipkit_tts_field aipkit_tts_openai_voice_row"
                data-provider="OpenAI"
                style="display: <?php echo ($tts_enabled === '1' && $tts_provider === 'OpenAI') ? 'block' : 'none'; ?>;"
            >
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_openai_voice_id_sheet"
                    >
                        <?php esc_html_e('Voice', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_inline_controls">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_openai_voice_id_sheet"
                            name="tts_openai_voice_id"
                            class="aipkit_popover_option_select"
                            aria-label="<?php esc_attr_e('Voice name', 'gpt3-ai-content-generator'); ?>"
                        >
                            <?php foreach ($openai_tts_voices as $voice): ?>
                                <option value="<?php echo esc_attr($voice['id']); ?>" <?php selected($tts_openai_voice_id, $voice['id']); ?>><?php echo esc_html($voice['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>

            <div
                class="aipkit_popover_option_row aipkit_tts_field aipkit_tts_openai_model_row"
                data-provider="OpenAI"
                style="display: <?php echo ($tts_enabled === '1' && $tts_provider === 'OpenAI') ? 'block' : 'none'; ?>;"
            >
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_openai_model_id_sheet"
                    >
                        <?php esc_html_e('Model', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_inline_controls">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_openai_model_id_sheet"
                            name="tts_openai_model_id"
                            class="aipkit_popover_option_select"
                            aria-label="<?php esc_attr_e('Voice model', 'gpt3-ai-content-generator'); ?>"
                        >
                            <?php
                            if (!empty($openai_tts_models)) {
                                foreach ($openai_tts_models as $model) {
                                    $model_id_val = $model['id'] ?? '';
                                    $model_name_val = $model['name'] ?? $model_id_val;
                                    echo '<option value="' . esc_attr($model_id_val) . '" ' . selected($tts_openai_model_id, $model_id_val, false) . '>' . esc_html($model_name_val) . '</option>';
                                }
                            } elseif (!empty($tts_openai_model_id)) {
                                echo '<option value="' . esc_attr($tts_openai_model_id) . '" selected>' . esc_html($tts_openai_model_id) . ' (Saved)</option>';
                            } else {
                                echo '<option value="' . esc_attr(\WPAICG\Chat\Storage\BotSettingsManager::DEFAULT_TTS_OPENAI_MODEL_ID) . '" selected>' . esc_html(\WPAICG\Chat\Storage\BotSettingsManager::DEFAULT_TTS_OPENAI_MODEL_ID) . ' (Default)</option>';
                            }
                            ?>
                        </select>
                    </div>
                </div>
            </div>

            <div
                class="aipkit_popover_option_row aipkit_tts_field aipkit_tts_google_voice_row"
                data-provider="Google"
                style="display: <?php echo ($tts_enabled === '1' && $tts_provider === 'Google') ? 'block' : 'none'; ?>;"
            >
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_google_voice_id_sheet"
                    >
                        <?php esc_html_e('Voice', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_inline_controls">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_google_voice_id_sheet"
                            name="tts_google_voice_id"
                            class="aipkit_popover_option_select"
                            aria-label="<?php esc_attr_e('Voice name', 'gpt3-ai-content-generator'); ?>"
                        >
                            <option value=""><?php esc_html_e('-- Select Voice --', 'gpt3-ai-content-generator'); ?></option>
                            <?php
                            if (!empty($google_tts_voices) && is_array($google_tts_voices)) {
                                $voices_by_lang = [];
                                foreach ($google_tts_voices as $voice) {
                                    if (!isset($voice['id'], $voice['name'], $voice['languageCodes'][0])) {
                                        continue;
                                    }
                                    $lang_code = $voice['languageCodes'][0];
                                    if (!isset($voices_by_lang[$lang_code])) {
                                        $voices_by_lang[$lang_code] = [];
                                    }
                                    $voices_by_lang[$lang_code][] = $voice;
                                }
                                ksort($voices_by_lang);
                                foreach ($voices_by_lang as $lang_code => $voices) {
                                    $lang_name = $lang_code;
                                    if (class_exists('IntlDisplayNames')) {
                                        try {
                                            $lang_name = \IntlDisplayNames::forLanguageTag($lang_code, 'en');
                                        } catch (\Exception $e) {
                                            $lang_name = $lang_code;
                                        }
                                    }
                                    echo '<optgroup label="' . esc_attr("{$lang_name} ({$lang_code})") . '">';
                                    usort($voices, fn($a, $b) => strcmp($a['name'], $b['name']));
                                    foreach ($voices as $voice) {
                                        echo '<option value="' . esc_attr($voice['id']) . '" ' . selected($tts_google_voice_id, $voice['id'], false) . '>' . esc_html($voice['name']) . '</option>';
                                    }
                                    echo '</optgroup>';
                                }
                            } elseif (!empty($tts_google_voice_id)) {
                                echo '<option value="' . esc_attr($tts_google_voice_id) . '" selected>' . esc_html($tts_google_voice_id) . ' (Saved)</option>';
                            }
                            ?>
                        </select>
                        <button
                            type="button"
                            class="aipkit_btn aipkit_btn-secondary aipkit_icon_btn aipkit_sync_btn aipkit_sync_tts_voices_btn"
                            data-provider="Google"
                            data-target-select="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_google_voice_id_sheet"
                        >
                            <span class="dashicons dashicons-update"></span>
                            <span class="aipkit_btn_label"><?php esc_html_e('Sync Voices', 'gpt3-ai-content-generator'); ?></span>
                        </button>
                    </div>
                </div>
            </div>

            <div
                class="aipkit_popover_option_row aipkit_tts_field aipkit_tts_elevenlabs_api_key_row"
                data-provider="ElevenLabs"
                style="display: <?php echo ($tts_enabled === '1' && $tts_provider === 'ElevenLabs') ? 'block' : 'none'; ?>;"
            >
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_elevenlabs_api_key_sheet"
                    >
                        <?php esc_html_e('API key', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_api-key-wrapper aipkit_popover_api_key_wrapper">
                        <input
                            type="password"
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_elevenlabs_api_key_sheet"
                            name="elevenlabs_api_key"
                            class="aipkit_form-input aipkit_popover_option_input aipkit_popover_option_input--wide aipkit_popover_option_input--framed"
                            value="<?php echo esc_attr($elevenlabs_api_key); ?>"
                            placeholder="<?php esc_attr_e('Enter your ElevenLabs API key', 'gpt3-ai-content-generator'); ?>"
                            autocomplete="new-password"
                            data-lpignore="true"
                            data-1p-ignore="true"
                            data-form-type="other"
                        />
                        <span class="aipkit_api-key-toggle">
                            <span class="dashicons dashicons-visibility"></span>
                        </span>
                    </div>
                </div>
            </div>

            <div
                class="aipkit_popover_option_row aipkit_tts_field aipkit_tts_elevenlabs_voice_row"
                data-provider="ElevenLabs"
                style="display: <?php echo ($tts_enabled === '1' && $tts_provider === 'ElevenLabs') ? 'block' : 'none'; ?>;"
            >
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_elevenlabs_voice_id_sheet"
                    >
                        <?php esc_html_e('Voice', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_inline_controls">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_elevenlabs_voice_id_sheet"
                            name="tts_elevenlabs_voice_id"
                            class="aipkit_popover_option_select"
                            aria-label="<?php esc_attr_e('Voice name', 'gpt3-ai-content-generator'); ?>"
                        >
                            <option value=""><?php esc_html_e('-- Select Voice --', 'gpt3-ai-content-generator'); ?></option>
                            <?php
                            if (!empty($elevenlabs_tts_voices) && is_array($elevenlabs_tts_voices)) {
                                foreach ($elevenlabs_tts_voices as $voice) {
                                    if (!isset($voice['id'], $voice['name'])) {
                                        continue;
                                    }
                                    echo '<option value="' . esc_attr($voice['id']) . '" ' . selected($tts_elevenlabs_voice_id, $voice['id'], false) . '>' . esc_html($voice['name']) . '</option>';
                                }
                            } elseif (!empty($tts_elevenlabs_voice_id)) {
                                echo '<option value="' . esc_attr($tts_elevenlabs_voice_id) . '" selected>' . esc_html($tts_elevenlabs_voice_id) . ' (Saved)</option>';
                            }
                            ?>
                        </select>
                        <button
                            type="button"
                            class="aipkit_btn aipkit_btn-secondary aipkit_icon_btn aipkit_sync_btn"
                            data-provider="ElevenLabs"
                            data-target-select="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_elevenlabs_voice_id_sheet"
                        >
                            <span class="dashicons dashicons-update"></span>
                            <span class="aipkit_btn_label"><?php esc_html_e('Sync Voices', 'gpt3-ai-content-generator'); ?></span>
                        </button>
                    </div>
                </div>
            </div>

            <div
                class="aipkit_popover_option_row aipkit_tts_field aipkit_tts_elevenlabs_model_row"
                data-provider="ElevenLabs"
                style="display: <?php echo ($tts_enabled === '1' && $tts_provider === 'ElevenLabs') ? 'block' : 'none'; ?>;"
            >
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_elevenlabs_model_id_sheet"
                    >
                        <?php esc_html_e('Model', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_inline_controls">
                        <select
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_elevenlabs_model_id_sheet"
                            name="tts_elevenlabs_model_id"
                            class="aipkit_popover_option_select"
                            aria-label="<?php esc_attr_e('Voice model', 'gpt3-ai-content-generator'); ?>"
                        >
                            <option value=""><?php esc_html_e('-- Select Model (Optional) --', 'gpt3-ai-content-generator'); ?></option>
                            <?php
                            if (!empty($elevenlabs_tts_models) && is_array($elevenlabs_tts_models)) {
                                foreach ($elevenlabs_tts_models as $model) {
                                    if (!isset($model['id'], $model['name'])) {
                                        continue;
                                    }
                                    echo '<option value="' . esc_attr($model['id']) . '" ' . selected($tts_elevenlabs_model_id, $model['id'], false) . '>' . esc_html($model['name']) . '</option>';
                                }
                            } elseif (!empty($tts_elevenlabs_model_id)) {
                                echo '<option value="' . esc_attr($tts_elevenlabs_model_id) . '" selected>' . esc_html($tts_elevenlabs_model_id) . ' (Saved)</option>';
                            }
                            ?>
                        </select>
                        <button
                            type="button"
                            class="aipkit_btn aipkit_btn-secondary aipkit_icon_btn aipkit_sync_btn"
                            data-provider="ElevenLabsModels"
                            data-target-select="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_elevenlabs_model_id_sheet"
                        >
                            <span class="dashicons dashicons-update"></span>
                            <span class="aipkit_btn_label"><?php esc_html_e('Sync Models', 'gpt3-ai-content-generator'); ?></span>
                        </button>
                    </div>
                </div>
            </div>

            <div class="aipkit_popover_option_row aipkit_tts_auto_play_container" style="display: <?php echo $tts_enabled === '1' ? 'block' : 'none'; ?>;">
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_auto_play_sheet"
                        data-tooltip="<?php echo esc_attr__('Auto-play bot responses.', 'gpt3-ai-content-generator'); ?>"
                    >
                        <?php esc_html_e('Auto play', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <label class="aipkit_switch">
                        <input
                            type="checkbox"
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_tts_auto_play_sheet"
                            name="tts_auto_play"
                            value="1"
                            <?php checked($tts_auto_play, '1'); ?>
                        />
                        <span class="aipkit_switch_slider"></span>
                    </label>
                </div>
            </div>

        </div>

    <div class="aipkit_popover_option_group">
            <div class="aipkit_popover_option_row aipkit_popover_option_row--section">
                <div class="aipkit_popover_option_main">
                    <span class="aipkit_popover_option_section_title">
                        <?php esc_html_e('Realtime voice agent', 'gpt3-ai-content-generator'); ?>
                    </span>
                </div>
            </div>
            <div class="aipkit_popover_option_row">
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_enable_realtime_voice_sheet"
                        data-tooltip="<?php echo esc_attr($rt_disabled_by_plan ? __('Upgrade to Pro to enable.', 'gpt3-ai-content-generator') : __('Enable live voice conversation.', 'gpt3-ai-content-generator')); ?>"
                    >
                        <?php esc_html_e('Enabled', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <div class="aipkit_popover_option_actions">
                        <label class="aipkit_switch">
                            <input
                                type="checkbox"
                                id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_enable_realtime_voice_sheet"
                                name="enable_realtime_voice"
                                class="aipkit_enable_realtime_voice_toggle"
                                value="1"
                                <?php checked($enable_realtime_voice, '1'); ?>
                                <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>
                                title="<?php echo esc_attr($rt_disabled_by_plan ? __('Upgrade to Pro to enable.', 'gpt3-ai-content-generator') : ''); ?>"
                            />
                            <span class="aipkit_switch_slider"></span>
                        </label>
                        <?php if ($rt_disabled_by_plan) : ?>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=wpaicg-pricing')); ?>" class="aipkit_popover_upgrade_link" title="<?php esc_attr_e('Upgrade to Pro', 'gpt3-ai-content-generator'); ?>"><?php esc_html_e('Upgrade', 'gpt3-ai-content-generator'); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="aipkit_popover_option_row aipkit_realtime_voice_inline_row aipkit_rt_dependent" style="display: <?php echo ($rt_force_visible || $enable_realtime_voice === '1') ? 'block' : 'none'; ?>;">
                <div class="aipkit_popover_option_main">
                    <span class="aipkit_popover_option_label">
                        <?php esc_html_e('Model', 'gpt3-ai-content-generator'); ?>
                    </span>
                    <div class="aipkit_popover_inline_controls aipkit_realtime_voice_inline_controls" style="display: <?php echo ($rt_force_visible || $enable_realtime_voice === '1') ? 'flex' : 'none'; ?>;">
                        <div class="aipkit_popover_inline_select">
                            <select
                                id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_realtime_model_sheet"
                                name="realtime_model"
                                class="aipkit_popover_option_select aipkit_popover_option_select--compact"
                                aria-label="<?php esc_attr_e('Realtime model', 'gpt3-ai-content-generator'); ?>"
                                <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>
                            >
                                <?php foreach ($realtime_models as $model_id): ?>
                                    <option value="<?php echo esc_attr($model_id); ?>" <?php selected($realtime_model, $model_id); ?>><?php echo esc_html($model_id); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="aipkit_popover_inline_select">
                            <select
                                id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_realtime_voice_sheet"
                                name="realtime_voice"
                                class="aipkit_popover_option_select aipkit_popover_option_select--compact"
                                aria-label="<?php esc_attr_e('Voice', 'gpt3-ai-content-generator'); ?>"
                                <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>
                            >
                                <?php foreach ($realtime_voices as $voice_id): ?>
                                    <option value="<?php echo esc_attr($voice_id); ?>" <?php selected($realtime_voice, $voice_id); ?>><?php echo esc_html(ucfirst($voice_id)); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="aipkit_popover_option_row aipkit_rt_dependent" data-tooltip-disabled="<?php echo esc_attr($direct_voice_mode_tooltip); ?>" title="<?php echo esc_attr($direct_voice_mode_tooltip); ?>">
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label <?php echo $direct_voice_mode_disabled ? 'aipkit-disabled-tooltip' : ''; ?>"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_direct_voice_mode_sheet"
                        data-tooltip="<?php echo esc_attr__('Auto-listen when the chat opens.', 'gpt3-ai-content-generator'); ?>"
                    >
                        <?php esc_html_e('Direct voice mode', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <label class="aipkit_switch">
                        <input
                            type="checkbox"
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_direct_voice_mode_sheet"
                            name="direct_voice_mode"
                            value="1"
                            <?php checked($direct_voice_mode, '1'); ?>
                            <?php echo $rt_controls_disabled ? 'disabled' : ''; ?> <?php disabled($direct_voice_mode_disabled); ?>
                        />
                        <span class="aipkit_switch_slider"></span>
                    </label>
                </div>
            </div>

            <div class="aipkit_popover_option_row aipkit_rt_dependent">
                <div class="aipkit_popover_option_main">
                    <label
                        class="aipkit_popover_option_label"
                        for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_input_audio_noise_reduction_sheet"
                        data-tooltip="<?php echo esc_attr__('Reduce background noise.', 'gpt3-ai-content-generator'); ?>"
                    >
                        <?php esc_html_e('Noise reduction', 'gpt3-ai-content-generator'); ?>
                    </label>
                    <label class="aipkit_switch">
                        <input
                            type="checkbox"
                            id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_input_audio_noise_reduction_sheet"
                            name="input_audio_noise_reduction"
                            value="1"
                            <?php checked($input_audio_noise_reduction, '1'); ?>
                            <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>
                        />
                        <span class="aipkit_switch_slider"></span>
                    </label>
                </div>
            </div>

            <div class="aipkit_realtime_voice_settings_container" style="display: <?php echo $rt_force_visible ? 'block' : (($enable_realtime_voice === '1') ? 'block' : 'none'); ?>;" <?php echo $rt_force_visible ? 'data-force-visible="1"' : ''; ?>>
                <div class="aipkit_popover_option_row aipkit_rt_dependent">
                    <div class="aipkit_popover_option_main">
                        <label
                            class="aipkit_popover_option_label"
                            for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_turn_detection_sheet"
                            data-tooltip="<?php echo esc_attr__('Decide when speech has ended.', 'gpt3-ai-content-generator'); ?>"
                        >
                            <?php esc_html_e('Turn detection', 'gpt3-ai-content-generator'); ?>
                        </label>
                        <select id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_turn_detection_sheet" name="turn_detection" class="aipkit_popover_option_select" <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>>
                            <option value="none" <?php selected($turn_detection, 'none'); ?>><?php esc_html_e('None (Push-to-Talk)', 'gpt3-ai-content-generator'); ?></option>
                            <option value="server_vad" <?php selected($turn_detection, 'server_vad'); ?>><?php esc_html_e('Automatic (Voice Activity)', 'gpt3-ai-content-generator'); ?></option>
                            <option value="semantic_vad" <?php selected($turn_detection, 'semantic_vad'); ?>><?php esc_html_e('Smart (Semantic Detection)', 'gpt3-ai-content-generator'); ?></option>
                        </select>
                    </div>
                </div>
                <div class="aipkit_popover_option_row aipkit_rt_dependent">
                    <div class="aipkit_popover_option_main">
                        <label
                            class="aipkit_popover_option_label"
                            data-tooltip="<?php echo esc_attr__('Format of audio sent and received.', 'gpt3-ai-content-generator'); ?>"
                        >
                            <?php esc_html_e('Audio format (in / out)', 'gpt3-ai-content-generator'); ?>
                        </label>
                        <div class="aipkit_popover_inline_controls">
                            <select id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_input_audio_format_sheet" name="input_audio_format" class="aipkit_popover_option_select aipkit_popover_option_select--compact" <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>>
                                <option value="pcm16" <?php selected($input_audio_format, 'pcm16'); ?>>pcm16</option>
                                <option value="g711_ulaw" <?php selected($input_audio_format, 'g711_ulaw'); ?>>g711_ulaw</option>
                                <option value="g711_alaw" <?php selected($input_audio_format, 'g711_alaw'); ?>>g711_alaw</option>
                            </select>
                            <select id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_output_audio_format_sheet" name="output_audio_format" class="aipkit_popover_option_select aipkit_popover_option_select--compact" <?php echo $rt_controls_disabled ? 'disabled' : ''; ?>>
                                <option value="pcm16" <?php selected($output_audio_format, 'pcm16'); ?>>pcm16</option>
                                <option value="g711_ulaw" <?php selected($output_audio_format, 'g711_ulaw'); ?>>g711_ulaw</option>
                                <option value="g711_alaw" <?php selected($output_audio_format, 'g711_alaw'); ?>>g711_alaw</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="aipkit_popover_option_row aipkit_rt_dependent">
                    <div class="aipkit_popover_option_main">
                        <label
                            class="aipkit_popover_option_label"
                            for="aipkit_bot_<?php echo esc_attr($bot_id); ?>_speed_sheet"
                            data-tooltip="<?php echo esc_attr__('Controls reply pacing.', 'gpt3-ai-content-generator'); ?>"
                        >
                            <?php esc_html_e('Response speed', 'gpt3-ai-content-generator'); ?>
                        </label>
                        <div class="aipkit_popover_param_slider">
                            <input type="range"
                                   id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_speed_sheet"
                                   name="speed"
                                   class="aipkit_form-input aipkit_range_slider aipkit_popover_slider"
                                   min="0.25"
                                   max="1.5"
                                   step="0.05"
                                   value="<?php echo esc_attr($speed); ?>"
                                   <?php echo $rt_controls_disabled ? 'disabled' : ''; ?> />
                            <span id="aipkit_bot_<?php echo esc_attr($bot_id); ?>_speed_sheet_value" class="aipkit_popover_param_value"><?php echo esc_html(number_format($speed, 2)); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
