<?php
// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/admin/views/dashboard.php
// Status: MODIFIED

// Silence direct access
if (!defined('ABSPATH')) {
    exit;
}

// Use the Dashboard_Beta class to retrieve module settings
use WPAICG\aipkit_dashboard;
use WPAICG\AIPKit_Role_Manager; // <-- Import Role Manager

// Retrieve the currently saved module settings
$moduleSettings = aipkit_dashboard::get_module_settings();

/**
 * Map each DB key to the nav label, dashicon, and the data-module attribute used for loading.
 * The data_module must match the folder name in /modules/ (e.g. 'chatbot', 'content-writer', etc.)
 * **AND** must match the keys used in AIPKit_Role_Manager::get_manageable_modules() for permission checks.
 *
 * Grouped by purpose for UX chunking:
 * - Primary: Core creation tools (always visible)
 * - Secondary: Supporting tools (in "More" dropdown on smaller screens or less used)
 */
$primaryModules = array(
    'chat_bot' => array(
        'label'       => __('Chatbots', 'gpt3-ai-content-generator'),
        'icon'        => 'format-chat',
        'data_module' => 'chatbot',
    ),
    'content_writer' => array(
        'label'       => __('Write', 'gpt3-ai-content-generator'),
        'icon'        => 'edit',
        'data_module' => 'content-writer',
    ),
    'autogpt' => array(
        'label'       => __('Automate', 'gpt3-ai-content-generator'),
        'icon'        => 'airplane',
        'data_module' => 'autogpt',
    ),
    'ai_forms' => array(
        'label'       => __('Forms', 'gpt3-ai-content-generator'),
        'icon'        => 'feedback',
        'data_module' => 'ai-forms',
    ),
    'image_generator' => array(
        'label'       => __('Images', 'gpt3-ai-content-generator'),
        'icon'        => 'format-image',
        'data_module' => 'image-generator',
    ),
);

$secondaryModules = array(
    'training' => array(
        'label'       => __('Train', 'gpt3-ai-content-generator'),
        'icon'        => 'welcome-learn-more',
        'data_module' => 'ai-training',
    ),
    'ai_account' => array(
        'label'       => __('Credits', 'gpt3-ai-content-generator'),
        'icon'        => 'tickets-alt',
        'data_module' => 'user-credits',
    ),
    'logs_viewer' => array(
        'label'       => __('Logs', 'gpt3-ai-content-generator'),
        'icon'        => 'list-view',
        'data_module' => 'logs',
    ),
);

// Combined for module settings dropdown
$modulesMap = array_merge($primaryModules, $secondaryModules);

// Create a nonce for AJAX requests
$aipkit_nonce = wp_create_nonce('aipkit_nonce');

?>
<div class="wrap aipkit_wrap">
    <div class="aipkit_module-tabs">
        <nav class="aipkit_module-tabs_list" role="tablist" aria-label="<?php esc_attr_e('Main navigation', 'gpt3-ai-content-generator'); ?>">
            <!-- Dashboard (Home) - Icon Only -->
            <?php if (AIPKit_Role_Manager::user_can_access_module('settings')): ?>
                <a
                    href="javascript:void(0);"
                    class="aipkit_module-tab aipkit_module-tab--home aipkit_module-link"
                    data-module="settings"
                    onclick="aipkit_loadModule('settings');"
                    aria-label="<?php esc_attr_e('Dashboard', 'gpt3-ai-content-generator'); ?>"
                    title="<?php esc_attr_e('Dashboard', 'gpt3-ai-content-generator'); ?>"
                    role="tab"
                >
                    <span class="dashicons dashicons-admin-home" aria-hidden="true"></span>
                </a>
            <?php endif; ?>

            <!-- Primary Modules Group - Always visible with icons + labels -->
            <div class="aipkit_nav_group aipkit_nav_group--primary">
                <?php foreach ($primaryModules as $optionKey => $mod) :
                    $module_slug = $mod['data_module'];
                    $is_enabled = !isset($moduleSettings[$optionKey]) || !empty($moduleSettings[$optionKey]);
                    if ($is_enabled && AIPKit_Role_Manager::user_can_access_module($module_slug)): ?>
                    <a
                        href="javascript:void(0);"
                        class="aipkit_module-tab aipkit_module-link"
                        data-module="<?php echo esc_attr($module_slug); ?>"
                        onclick="aipkit_loadModule('<?php echo esc_js($module_slug); ?>')"
                        role="tab"
                    >
                        <span class="dashicons dashicons-<?php echo esc_attr($mod['icon']); ?>" aria-hidden="true"></span>
                        <span class="aipkit_module-tab_label"><?php echo esc_html($mod['label']); ?></span>
                    </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>

            <!-- Divider -->
            <span class="aipkit_nav_divider" aria-hidden="true"></span>

            <!-- Secondary Modules Group - Icon only with tooltips (less prominent) -->
            <div class="aipkit_nav_group aipkit_nav_group--secondary">
                <?php foreach ($secondaryModules as $optionKey => $mod) :
                    $module_slug = $mod['data_module'];
                    $is_enabled = !isset($moduleSettings[$optionKey]) || !empty($moduleSettings[$optionKey]);
                    if ($is_enabled && AIPKit_Role_Manager::user_can_access_module($module_slug)): ?>
                    <a
                        href="javascript:void(0);"
                        class="aipkit_module-tab aipkit_module-tab--icon aipkit_module-link"
                        data-module="<?php echo esc_attr($module_slug); ?>"
                        onclick="aipkit_loadModule('<?php echo esc_js($module_slug); ?>')"
                        aria-label="<?php echo esc_attr($mod['label']); ?>"
                        title="<?php echo esc_attr($mod['label']); ?>"
                        role="tab"
                    >
                        <span class="dashicons dashicons-<?php echo esc_attr($mod['icon']); ?>" aria-hidden="true"></span>
                    </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </nav>

        <?php if (current_user_can('manage_options')): ?>
            <div class="aipkit_module-tabs_actions">
                <div
                    class="aipkit_modules-menu"
                    id="aipkit_modulesMenu"
                    title="<?php echo esc_attr__('Module Settings', 'gpt3-ai-content-generator'); ?>"
                >
                    <button class="aipkit_menu-trigger" type="button" aria-label="<?php echo esc_attr__('Module Settings', 'gpt3-ai-content-generator'); ?>" aria-haspopup="true" aria-expanded="false">
                        <svg class="aipkit_menu-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="3"></circle>
                            <path d="m19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1 1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path>
                        </svg>
                    </button>
                    <div class="aipkit_dropdown-panel" role="dialog" aria-labelledby="aipkit_modules_panel_title">
                        <div class="aipkit_panel-header">
                            <h3 id="aipkit_modules_panel_title"><?php echo esc_html__('Modules', 'gpt3-ai-content-generator'); ?></h3>
                            <p><?php echo esc_html__('Toggle visibility of modules', 'gpt3-ai-content-generator'); ?></p>
                        </div>
                        <div class="aipkit_modules-list">
                            <?php foreach ($modulesMap as $optionKey => $mod) :
                                $checked = !isset($moduleSettings[$optionKey]) || !empty($moduleSettings[$optionKey]) ? 'checked' : '';
                                $inputId = 'aipkit_toggle_' . esc_attr($optionKey);
                            ?>
                                <label class="aipkit_module-item" for="<?php echo esc_attr($inputId); ?>">
                                    <div class="aipkit_module-info">
                                        <span class="aipkit_module-icon dashicons dashicons-<?php echo esc_attr($mod['icon']); ?>" aria-hidden="true"></span>
                                        <span class="aipkit_module-label"><?php echo esc_html($mod['label']); ?></span>
                                    </div>
                                    <span class="aipkit_toggle-switch">
                                        <input
                                            type="checkbox"
                                            id="<?php echo esc_attr($inputId); ?>"
                                            name="<?php echo esc_attr($optionKey); ?>"
                                            class="aipkit_module-toggle"
                                            data-module="<?php echo esc_attr($mod['data_module']); ?>"
                                            data-option-key="<?php echo esc_attr($optionKey); ?>"
                                            data-icon="<?php echo esc_attr($mod['icon']); ?>"
                                            data-label="<?php echo esc_attr($mod['label']); ?>"
                                            <?php echo $checked ? 'checked' : ''; ?>
                                        >
                                        <span class="aipkit_toggle-slider"></span>
                                    </span>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Main content area -->
    <div class="aipkit_main-content" id="aipkit_module-container">
        <!-- Module content will be loaded here -->
    </div>
</div>
