<?php

// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/admin/data/dashboard-localized-texts.php
// Status: MODIFIED
/**
 * Defines the localized text strings used in the AIPKit Dashboard JavaScript.
 * Returns an array of strings, keyed by their identifier.
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

return [
    // General / Loader
    /* translators: %s is the name of the module being loaded */
    'loading'                   => __('Loading %s...', 'gpt3-ai-content-generator'),
    'errorLoadingModuleTitle'   => __('Error Loading Module', 'gpt3-ai-content-generator'),
    /* translators: %s is the name of the module that failed to load */
    'errorLoadingModuleMsg'     => __('An error occurred while loading the \'%s\' module. Please try again later or check the browser console for details.', 'gpt3-ai-content-generator'),
    'errorDetails'              => __('Details:', 'gpt3-ai-content-generator'),
    'noKnowledgeBasesFound' => __('No knowledge bases found. Click "Add Content" to create one.', 'gpt3-ai-content-generator'),
    // Chat Preview Placeholders
    'previewPlaceholderSelect'  => __('Select a bot to see the preview.', 'gpt3-ai-content-generator'),
    'previewPlaceholderCreate'  => __('Configure the new bot and save it to see the preview.', 'gpt3-ai-content-generator'),
    'previewPlaceholderSettings' => __('Preview is not applicable for Chat Settings.', 'gpt3-ai-content-generator'),
    'previewPlaceholderLogs'    => __('Preview is not applicable for Chat Logs.', 'gpt3-ai-content-generator'),
    'noBotsPlaceholder'         => __('No chatbots found. Create one to get started!', 'gpt3-ai-content-generator'),
    // Logs Viewer
    'logViewTitle'              => __('Chat Log Details', 'gpt3-ai-content-generator'),
    'logLoading'                => __('Loading log details...', 'gpt3-ai-content-generator'),
    'logErrorLoading'           => __('Error loading log details.', 'gpt3-ai-content-generator'),
    'logBotLabel'               => __('Bot', 'gpt3-ai-content-generator'),
    'logUserLabel'              => __('User', 'gpt3-ai-content-generator'),
    'logSessionLabel'           => __('Session ID', 'gpt3-ai-content-generator'),
    'logStartLabel'             => __('Started', 'gpt3-ai-content-generator'),
    'logLastActivityLabel'      => __('Last Activity', 'gpt3-ai-content-generator'),
    'logProviderLabel'          => __('Provider', 'gpt3-ai-content-generator'),
    'logModelLabel'             => __('Model', 'gpt3-ai-content-generator'),
    'logIpLabel'                => __('IP Address', 'gpt3-ai-content-generator'),
    'noLogsFound'               => __('No logs found matching your criteria.', 'gpt3-ai-content-generator'),
    'logExportFilteredConfirmMsg' => __('Export all messages matching current filters?', 'gpt3-ai-content-generator'),
    'logExportAllConfirmMsg'    => __('Export all messages? This might take a while for large datasets.', 'gpt3-ai-content-generator'),
    'logExportStarting'         => __('Starting...', 'gpt3-ai-content-generator'),
    /* translators: %1$d is the current conversation number, %2$d is the total number of conversations */
    'logExportProgress' 		=> __('Exporting conversation %1$d / %2$d...', 'gpt3-ai-content-generator'),
    'logExportComplete'         => __('Done!', 'gpt3-ai-content-generator'),
    'logExportError'            => __('Export failed:', 'gpt3-ai-content-generator'),
    'logExportNoLogs'           => __('No messages found to export.', 'gpt3-ai-content-generator'),
    'logDeleteFilteredConfirmMsg' => __('Delete all conversations matching current filters? This action cannot be undone.', 'gpt3-ai-content-generator'),
    'logDeleteAllConfirmMsg'    => __('Delete ALL conversations? This will remove ALL chat history and cannot be undone.', 'gpt3-ai-content-generator'),
    'logDeleteStarting'         => __('Starting...', 'gpt3-ai-content-generator'),
    /* translators: %1$d is the current conversation number, %2$d is the total number of conversations */
    'logDeleteProgress' 		=> __('Deleting conversation %1$d / %2$d...', 'gpt3-ai-content-generator'),
    'logDeleteComplete'         => __('Done!', 'gpt3-ai-content-generator'),
    'logDeleteError'            => __('Deletion failed:', 'gpt3-ai-content-generator'),
    'logDeleteNoLogs'           => __('No conversations found to delete.', 'gpt3-ai-content-generator'),
    'confirm'                   => __('Confirm', 'gpt3-ai-content-generator'),
    'confirmDeleteFiltered'     => __('Confirm Delete Filtered', 'gpt3-ai-content-generator'),
    'confirmDeleteAll'          => __('Confirm Delete ALL', 'gpt3-ai-content-generator'),
    'cancel'                    => __('Cancel', 'gpt3-ai-content-generator'),
    // Settings Chart
    'chartLoading'              => __('Loading chart data...', 'gpt3-ai-content-generator'),
    'chartError'                => __('Error loading chart data.', 'gpt3-ai-content-generator'),
    'chartNoData'               => __('No token usage data found for the selected period.', 'gpt3-ai-content-generator'),
    // Frontend Chat UI (subset needed for preview)
    'sendMessage'               => __('Send Message', 'gpt3-ai-content-generator'),
    'sending'                   => __('Sending...', 'gpt3-ai-content-generator'),
    'typeMessage'               => __('Type your message...', 'gpt3-ai-content-generator'),
    'thinking'                  => __('Thinking', 'gpt3-ai-content-generator'),
    'streaming'                 => __('Streaming...', 'gpt3-ai-content-generator'),
    'errorPrefix'               => __('Error:', 'gpt3-ai-content-generator'),
    'userPrefix'                => __('User', 'gpt3-ai-content-generator'),
    'clearChat'                 => __('Clear Chat', 'gpt3-ai-content-generator'),
    'fullscreen'                => __('Fullscreen', 'gpt3-ai-content-generator'),
    'exitFullscreen'            => __('Exit Fullscreen', 'gpt3-ai-content-generator'),
    'download'                  => __('Download Transcript', 'gpt3-ai-content-generator'),
    'downloadTxt'               => __('Download TXT', 'gpt3-ai-content-generator'),
    'downloadPdf'               => __('Download PDF', 'gpt3-ai-content-generator'),
    'downloadEmpty'             => __('Nothing to download.', 'gpt3-ai-content-generator'),
    'pdfError'                  => __('Could not generate PDF. jsPDF library might be missing.', 'gpt3-ai-content-generator'),
    'streamError'               => __('Stream error. Please try again.', 'gpt3-ai-content-generator'),
    'connError'                 => __('Connection error. Please try again.', 'gpt3-ai-content-generator'),
    'copyActionLabel'           => __('Copy response', 'gpt3-ai-content-generator'),
    'copySuccess'               => __('Copied!', 'gpt3-ai-content-generator'),
    'copyFail'                  => __('Failed to copy', 'gpt3-ai-content-generator'),
    'feedbackLikeLabel'         => __('Like response', 'gpt3-ai-content-generator'),
    'feedbackDislikeLabel'      => __('Dislike response', 'gpt3-ai-content-generator'),
    'feedbackSubmitted'         => __('Feedback submitted', 'gpt3-ai-content-generator'),
    'feedbackError'             => __('Error saving feedback', 'gpt3-ai-content-generator'),
    'sidebarToggle'             => __('Toggle Conversation Sidebar', 'gpt3-ai-content-generator'),
    'newChat'                   => __('New Chat', 'gpt3-ai-content-generator'),
    'conversations'             => __('Conversations', 'gpt3-ai-content-generator'),
    'historyGuests'             => __('History unavailable for guests.', 'gpt3-ai-content-generator'),
    'historyEmpty'              => __('No past conversations.', 'gpt3-ai-content-generator'),
    'playActionLabel'           => __('Play audio', 'gpt3-ai-content-generator'),
    'pauseActionLabel'          => __('Pause audio', 'gpt3-ai-content-generator'),
    // User Credits
    'userCreditsLoading'        => __('Loading user credits...', 'gpt3-ai-content-generator'),
    'userCreditsError'          => __('Error loading user credits.', 'gpt3-ai-content-generator'),
    'userCreditsNoUsers'        => __('No user token data found.', 'gpt3-ai-content-generator'),
    'userCreditsEdit'           => __('Edit Credits', 'gpt3-ai-content-generator'),
    'userCreditsReset'          => __('Reset Period', 'gpt3-ai-content-generator'),
    // Vector Store Specific
    'vectorSearching'           => __('Searching vector store...', 'gpt3-ai-content-generator'),
    // Automated Tasks Specific (Renamed from Auto Indexer)
    'confirm_delete_task'        => __('Are you sure you want to delete this automated task? This action cannot be undone.', 'gpt3-ai-content-generator'),
    'task_name_required'         => __('Task name is required.', 'gpt3-ai-content-generator'),
    'task_type_required'         => __('Task type is required.', 'gpt3-ai-content-generator'),
    'target_store_required'     => __('Please select a target vector store.', 'gpt3-ai-content-generator'),
    'content_type_required'     => __('Please select at least one content type.', 'gpt3-ai-content-generator'),
    'saving_task'                => __('Saving Task...', 'gpt3-ai-content-generator'),
    'deleting_task'              => __('Deleting Task...', 'gpt3-ai-content-generator'),
    'running_task'               => __('Initiating Run...', 'gpt3-ai-content-generator'),
    'pausing_task'               => __('Pausing Task...', 'gpt3-ai-content-generator'),
    'resuming_task'              => __('Resuming Task...', 'gpt3-ai-content-generator'),
    'save_task_button'           => __('Save Task', 'gpt3-ai-content-generator'),
    'create_task_button'         => __('Create Task', 'gpt3-ai-content-generator'),
    'edit_generated_post_title'  => __('Edit generated post', 'gpt3-ai-content-generator'),
    'wizard_next_button'         => __('Next', 'gpt3-ai-content-generator'),
    'content_title_required_cw_task' => __('Topic is required for Content Writing task.', 'gpt3-ai-content-generator'),
    'ai_config_required_cw_task' => __('AI Provider and Model are required for Content Writing task.', 'gpt3-ai-content-generator'),
    'task_queued_content_writing' => __('Your content writing task is queued. You can track it under the Automated Tasks tab.', 'gpt3-ai-content-generator'),
    'formsLoading'                => __('Loading forms...', 'gpt3-ai-content-generator'),
    'formsErrorLoading'           => __('Error loading forms data.', 'gpt3-ai-content-generator'),
    'formsNoFormsFound'           => __('No AI Forms have been created yet.', 'gpt3-ai-content-generator'),
    'formsCreateNewButton'        => __('Create New AI Form', 'gpt3-ai-content-generator'),
    'formsPlaceholderTitle'       => __('e.g., Product Description Generator', 'gpt3-ai-content-generator'),
    'formsPromptLabel'            => __('Prompt Template', 'gpt3-ai-content-generator'),
    'formsPromptHelp'             => __('Craft your prompt. Use {user_input} as a placeholder for the user\'s text from the form.', 'gpt3-ai-content-generator'),
    'formsSaveButton'             => __('Save Form', 'gpt3-ai-content-generator'),
    'formsCreatingButton'         => __('Creating Form...', 'gpt3-ai-content-generator'),
    'formElementsPaletteTitle'    => __('Form Elements', 'gpt3-ai-content-generator'),
    'formDesignerAreaTitle'       => __('Form Designer', 'gpt3-ai-content-generator'),
    'formDesignerPlaceholder'     => __('Drag Form Elements Here', 'gpt3-ai-content-generator'),
    'formElementTypeTextInput'    => __('Text Input', 'gpt3-ai-content-generator'),
    'formElementTypeTextarea'     => __('Text Area', 'gpt3-ai-content-generator'),
    'formElementTypeSelect'       => __('Dropdown', 'gpt3-ai-content-generator'),
    'formElementTypeCheckbox'     => __('Checkbox', 'gpt3-ai-content-generator'),
    'formElementDragHelp'         => __('Drag elements to the designer area.', 'gpt3-ai-content-generator'),
    'elementSettingsTitle'        => __('Element Settings', 'gpt3-ai-content-generator'),
    'settingsLabelText'           => __('Label Text', 'gpt3-ai-content-generator'),
    'settingsFieldVarName'        => __('Field Variable Name (for prompt)', 'gpt3-ai-content-generator'),
    'settingsFieldVarNameHelp'    => __('Use as {your_variable_name} in the Prompt Template. Must be unique and contain only letters, numbers, underscores.', 'gpt3-ai-content-generator'),
    'settingsPlaceholderText'     => __('Placeholder Text', 'gpt3-ai-content-generator'),
    'settingsRequiredField'       => __('Required Field', 'gpt3-ai-content-generator'),
    'settingsSelectOptions'       => __('Options (Value|Text)', 'gpt3-ai-content-generator'),
    'settingsSelectOptionValue'   => __('Value', 'gpt3-ai-content-generator'),
    'settingsSelectOptionText'    => __('Display Text', 'gpt3-ai-content-generator'),
    'settingsAddOption'           => __('Add Option', 'gpt3-ai-content-generator'),
    'settingsRemoveOption'        => __('Remove Option', 'gpt3-ai-content-generator'),
    'settingsDoneButton'          => __('Done', 'gpt3-ai-content-generator'),
    /* translators: %s is the type of form element, e.g. Text Input */
    'settingsPanelElementType'    => __('(%s)', 'gpt3-ai-content-generator'), // e.g. (Text Input)
    'errorUniqueFieldId'          => __('Field Variable Name must be unique and valid (letters, numbers, underscores).', 'gpt3-ai-content-generator'),
    // --- END MODIFIED ---
    'task_singular' => __('task', 'gpt3-ai-content-generator'),
    'task_plural' => __('tasks', 'gpt3-ai-content-generator'),
];
