<?php
/**
 * Uninstall Gozer
 *
 * Removes all plugin data when the plugin is deleted.
 *
 * @package Gozer
 * @since   1.0.0
 */

// Exit if not called by WordPress.
defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

// Delete plugin options.
delete_option( 'gozer_settings' );
delete_option( 'gozer_bypass_tokens' );

// Clear scheduled events.
wp_clear_scheduled_hook( 'gozer_cleanup_tokens' );

// Clear any transients.
delete_transient( 'gozer_activation_notice' );
