/**
 * Admin scripts for Gozer
 *
 * @package Gozer
 * @since   1.0.0
 */

( function( $ ) {
	'use strict';

	$( document ).ready( function() {
		initRedirectTypeToggle();
		initTokenGenerator();
		initTokenActions();
	} );

	/**
	 * Toggle custom URL field visibility.
	 */
	function initRedirectTypeToggle() {
		var $redirectInputs = $( 'input[name="gozer_settings[redirect_type]"]' );
		var $customUrlRow = $( '#gozer-custom-url-row' );

		$redirectInputs.on( 'change', function() {
			var selectedValue = $( 'input[name="gozer_settings[redirect_type]"]:checked' ).val();

			if ( 'url' === selectedValue ) {
				$customUrlRow.slideDown( 200 );
			} else {
				$customUrlRow.slideUp( 200 );
			}
		} );
	}

	/**
	 * Handle token generation.
	 */
	function initTokenGenerator() {
		$( '#gozer-generate-token' ).on( 'click', function() {
			var $button = $( this );
			var hours = $( '#gozer-token-hours' ).val();
			var note = $( '#gozer-token-note' ).val();

			$button.prop( 'disabled', true );

			$.ajax( {
				url: gozer.ajaxUrl,
				type: 'POST',
				data: {
					action: 'gozer_generate_token',
					nonce: gozer.nonce,
					hours: hours,
					note: note
				},
				success: function( response ) {
					if ( response.success ) {
						location.reload();
					}
				},
				complete: function() {
					$button.prop( 'disabled', false );
				}
			} );
		} );
	}

	/**
	 * Handle token actions (copy, delete).
	 */
	function initTokenActions() {
		// Copy token URL.
		$( document ).on( 'click', '.gozer-copy-token', function() {
			var url = $( this ).data( 'url' );
			var $button = $( this );

			navigator.clipboard.writeText( url ).then( function() {
				var originalText = $button.text();
				$button.text( gozer.copied );
				setTimeout( function() {
					$button.text( originalText );
				}, 2000 );
			} );
		} );

		// Delete token.
		$( document ).on( 'click', '.gozer-delete-token', function() {
			if ( ! confirm( gozer.confirmDelete ) ) {
				return;
			}

			var $button = $( this );
			var index = $button.data( 'index' );

			$button.prop( 'disabled', true );

			$.ajax( {
				url: gozer.ajaxUrl,
				type: 'POST',
				data: {
					action: 'gozer_delete_token',
					nonce: gozer.nonce,
					index: index
				},
				success: function( response ) {
					if ( response.success ) {
						$button.closest( 'tr' ).fadeOut( 300, function() {
							$( this ).remove();
							if ( $( '.gozer-tokens-table tbody tr' ).length === 0 ) {
								location.reload();
							}
						} );
					}
				},
				complete: function() {
					$button.prop( 'disabled', false );
				}
			} );
		} );
	}

} )( jQuery );
