/**
 * Admin Bar scripts for Gozer
 *
 * Handles the toggle switch functionality in the admin bar.
 *
 * @package Gozer
 * @since   1.0.0
 */

( function() {
	'use strict';

	/**
	 * Initialize toggle functionality when DOM is ready.
	 */
	document.addEventListener( 'DOMContentLoaded', function() {
		initToggle();
	} );

	/**
	 * Handle toggle checkbox change event.
	 *
	 * Sends AJAX request to enable/disable force login
	 * and reloads the page on success.
	 */
	function initToggle() {
		var checkbox = document.getElementById( 'gozer-toggle-checkbox' );

		if ( ! checkbox ) {
			return;
		}

		checkbox.addEventListener( 'change', function( e ) {
			e.preventDefault();

			var enabled = this.checked ? 1 : 0;
			var data = new FormData();

			data.append( 'action', 'gozer_toggle' );
			data.append( 'enabled', enabled );
			data.append( 'nonce', gozerBar.nonce );

			fetch( gozerBar.ajaxUrl, {
				method: 'POST',
				credentials: 'same-origin',
				body: data
			} )
			.then( function( response ) {
				return response.json();
			} )
			.then( function( data ) {
				if ( data.success ) {
					location.reload();
				}
			} );
		} );
	}

} )();
