<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $grp_wp_query, $grp_config_settings, $grp_post_type;

//echo "<pre>"; print_r($grp_config_settings); echo "</pre>";

$heading = $grp_config_settings['layout']['heading'] ? $grp_config_settings['layout']['heading'] : '';
$per_row_posts = $grp_config_settings['layout']['per_row_posts'] ? $grp_config_settings['layout']['per_row_posts'] : 4;

$show_thumb = $grp_config_settings['layout']['show_thumb'] ? $grp_config_settings['layout']['show_thumb'] : '';
$thumb_size = $grp_config_settings['layout']['thumb_size'] ? $grp_config_settings['layout']['thumb_size'] : '';
$default_image = $grp_config_settings['layout']['default_image'] ? $grp_config_settings['layout']['default_image'] : '';

$show_title = $grp_config_settings['layout']['show_title'] ? $grp_config_settings['layout']['show_title'] : '';
$show_date = $grp_config_settings['layout']['show_date'] ? $grp_config_settings['layout']['show_date'] : '';
$show_author = $grp_config_settings['layout']['show_author'] ? $grp_config_settings['layout']['show_author'] : '';
$show_categories = $grp_config_settings['layout']['show_categories'] ? $grp_config_settings['layout']['show_categories'] : '';
$show_which_categories = $grp_config_settings['layout']['show_which_categories'] ? $grp_config_settings['layout']['show_which_categories'] : '';
$show_excerpt = $grp_config_settings['layout']['show_excerpt'] ? $grp_config_settings['layout']['show_excerpt'] : '';
$excerpt_length = $grp_config_settings['layout']['excerpt_length'] ? $grp_config_settings['layout']['excerpt_length'] : 10;
$read_more = $grp_config_settings['layout']['read_more'] ? $grp_config_settings['layout']['read_more'] : '';


?>

<div class="grp-related-posts-container">

	<h3><?php echo esc_html( $heading ); ?></h3>

    <div class="grp-default-list grp-<?php echo esc_attr( $grp_post_type );?>-listing">
    
		<?php
        
        if ( $grp_wp_query->have_posts() ) {
            
            while ( $grp_wp_query->have_posts() ) : $grp_wp_query->the_post();
            
                ?>
                
                <div class="grp-items">
                	
                    <div class="grp-items-inner">
                    	
                        <?php if( $show_thumb == 1 ){ ?>
                        
                            <div class="carousel-item active">
                                <a href="<?php the_permalink();?>" class="geodir-link-image embed-has-action embed-responsive embed-responsive-16by9 d-block">
                                <?php
								
								if( has_post_thumbnail( get_the_ID() ) ){
                                
                                	$thumb_size = is_string( $thumb_size ) || is_array( $thumb_size )
                                        ? $thumb_size
                                        : 'thumbnail';

                                    $post_thumbnail_html = get_the_post_thumbnail( get_the_ID(), $thumb_size );

                                    echo wp_kses_post( $post_thumbnail_html );
								
								}elseif( $default_image > 0 ){
								
									echo wp_get_attachment_image( $default_image, $thumb_size );
								
								}
                                
                                ?>
                                </a>
                            </div>
                        
                        <?php } ?>
                        
                        <div class="grp-item-fields">
                        	
                            <?php if( $show_title == 1 ){ ?>
                            
                            	<div class="grp-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></div>
                            
                            <?php } ?>
                            
                            
                            <?php if( $show_date == 1 || $show_author == 1 ){ ?>
                            
                                <div class="grp-createddate-author">
                                
                                    <?php if( $show_date == 1 ){ ?>
                                    
                                        <div class="grp-created-date"><i aria-hidden="true" class="far fa-clock"></i><?php echo get_the_date();?></div>
                                    
                                    <?php } ?>
                                    
                                    
                                    <?php if( $show_author == 1 ){ ?>
                                    
                                        <div class="grp-post-author"><?php echo get_avatar( get_the_ID(), 20, '', '' ); ?><span><?php echo get_the_author();?></span></div>
                                    
                                    <?php } ?>
                                    
                                    <div style="clear:both;"></div>
                                
                                </div>
                           
                           <?php } ?> 
                           
                            
                            <?php if( $show_categories == 1 ){ ?>
                            
                                <div class="grp-categories">
                                
                                    <?php
                                    
                                    $categories_obj = wp_get_post_terms( get_the_ID(), $show_which_categories, array( 'fields' => 'all' ) );
                                    
									$categories_array = array();
									
									if( !empty( $categories_obj ) ){
										
										foreach( $categories_obj as $catkey => $catval ){
											
											$categories_array[] = '<a href="'.get_term_link( $catval->term_id ).'">'.$catval->name.'</a>';
										
										}
									
									}
									
                                    $categories_string = !empty($categories_array) ? implode(', ', $categories_array) : '';
                                    
									echo wp_kses_post( $categories_string );
									
                                    ?>
                                
                                </div>
                            
                            <?php } ?>
                            
                            
                            <?php if( $show_excerpt == 1 ){ ?>
                            
                                <div class="grp-excerpt-container">
                                
                                    <div class="grp-excerpt">
                                    
                                    <?php
									
									$excerpt = grp_strip_tags( get_the_content() );
									
                                    preg_replace( '/([,;.-]+)\s*/', '\1 ', $excerpt );
									
									$excerp_arr = preg_split( '/\s+/', $excerpt );
									
									$show_dots = '';
									$show_read_more = false;
									if( count($excerp_arr) > $excerpt_length ){
									
										$show_read_more = true;
										
										if( $read_more != 'yes' && $read_more != 'always' ){
											
											$show_dots = __( '...', 'gou-manage-related-posts-similar-posts' );
											
										}
									}
									
                                    $excerpt = implode( ' ', array_slice( preg_split( '/\s+/', $excerpt ), 0, $excerpt_length ) ) . $show_dots;
                                    
									echo esc_html( $excerpt );
									
                                    ?>
                                    
                                    <?php if( ( $read_more == 'yes' && $show_read_more ) || $read_more == 'always' ){ ?>
                                    
                                    	<a href="<?php the_permalink();?>" class="grp-read-more " style=""><?php echo esc_html__( 'Read More...', 'gou-manage-related-posts-similar-posts' );?></a>
                                    
                                    <?php } ?>
                                    
                                    </div>
                                    
                                </div>
                            
                            <?php } ?>
                            
                            
                        </div>
                        
                    </div>
                
                </div>
                
                <?php
            
            endwhile;
            
        }
        
		
		wp_reset_postdata();
		
        ?>
    
    </div>

</div>

