<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class GRP_Custom_Templates {

	
	public static function init() {
		
		add_filter( 'the_content', array( __CLASS__, 'grp_the_content' ), 10 );
		
		/*add_action( 'wp_enqueue_scripts', array( __CLASS__, 'grp_template_script' ), 10 );*/
		
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'grp_frontend_style' ), 10 );
		
	}
	
	public static function grp_the_content( $content ){
		
		global $post;
		
		if ( ! is_singular() && ( !is_archive() || !is_home() ) ) {
			
			return $content;
			
		}
		
		$post_type = get_post_type( $post );
		
		$content .= self::grp_get_template_data( $post_type ); //show content....
		
		return $content;
		
	}
	
	public static function grp_get_template_data( $post_type, $shortcode = array() ) {
		
		global $post, $grp_wp_query, $grp_config_settings, $grp_post_type;
		
		$settings = GRP_Post_Filters::grp_get_configuration_settings();
		$global_settings = isset( $settings['global'] ) ? $settings['global'] : '';
		$config_settings = isset( $settings['config'] ) ? $settings['config'] : '';
		
		$is_disabled = isset( $global_settings['is_disabled'] ) ? $global_settings['is_disabled'] : '';
		
		if( $is_disabled == 'yes' || !$post_type || !isset( $config_settings[$post_type] ) )
			return;
		
        $is_enable = isset( $config_settings[$post_type]['is_enable'] ) ? $config_settings[$post_type]['is_enable'] : '';
        
		if( $is_enable != 'yes' )
			return;
			
		$grp_config_settings = $config_settings[$post_type];
		$grp_post_type = $post_type;
		
		$max_posts = isset( $config_settings[$post_type]['layout']['max_posts'] ) ? $config_settings[$post_type]['layout']['max_posts'] : 10;
		
		$match_case_terms = isset( $config_settings[$post_type]['match_case'] ) ? $config_settings[$post_type]['match_case'] : array();
		$exclude_terms = isset( $config_settings[$post_type]['exclude'] ) ? $config_settings[$post_type]['exclude'] : array();
		
		$order_by = isset( $config_settings[$post_type]['order_by'] ) ? $config_settings[$post_type]['order_by'] : '';
		
		//echo "<pre>"; print_r($config_settings[$post_type]); echo "</pre>";
		//echo "<pre>"; print_r($exclude_terms); echo "</pre>";
		
		global $wp_query;
		
		//store query post data...
		$grp_store_query_post = $wp_query;
		
		$wp_query = new WP_Query();
		
		$tax_query = array();
		$exluded_terms = array();
		
		if( !empty( $match_case_terms ) ){
			
			$within_match = array( 'relation' => 'OR' );
			$match_one_cat = array( 'relation' => 'AND' );
			
			foreach( $match_case_terms as $key => $val ){
				
				$post_terms = wp_get_post_terms( $post->ID, $key, array( 'fields' => 'ids' ) );
				
				//get exclude posts...
				if( isset( $exclude_terms[$key] ) && !empty( $exclude_terms[$key] ) ){
					
					$exluded_terms[] = array(
					   'taxonomy' => $key,
					   'field' => 'id',
					   'terms' => $exclude_terms[$key],
					   'operator' => 'NOT IN',
					 );
					
					//if exclude terms also in current post...
					$post_exclude_terms = array_intersect( $exclude_terms[$key], $post_terms );
					
					if( !empty( $post_exclude_terms ) ){
						return;
					}
					   
				}
				
				if( $val == 'within_match' ){
					
					$within_match[] = array(
					   'taxonomy' => $key,
					   'field' => 'id',
					   'terms' => $post_terms,
					 );
				
				}elseif( $val == 'match_one_cat' ){
					
					$match_one_cat[] = array(
					   'taxonomy' => $key,
					   'field' => 'id',
					   'terms' => $post_terms
					 );
				
				}
				
			}
			
			$tax_query = isset( $match_one_cat[0] ) ? $match_one_cat : '';
			$tax_query = ( isset( $within_match[0] ) && empty( $tax_query ) ) ? $within_match : $tax_query;
			
		}
		
		//set order by...
		$order_by_parts = explode('_', $order_by);
		$order_by_last = array_pop($order_by_parts);
		$order_by_arr = array(implode('_', $order_by_parts), $order_by_last);
		
		$order_by = isset( $order_by_arr[0] ) ? $order_by_arr[0] : $order_by;
		$order = isset( $order_by_arr[1] ) ? $order_by_arr[1] : '';
		
		$query_args = array(
		
			'posts_per_page' => $max_posts,
			'post_type' => $post_type,
			'post_status' => 'publish',
			'post__not_in' => array( $post->ID ),
			'grp_related_posts_query' => '1',
			'orderby' => $order_by,
            'order'   => $order
			
		);
		
		if( !empty( $tax_query ) ){
			
			$query_args['tax_query'] = array( 'relation' => 'AND' );
			$query_args['tax_query'][] = $tax_query;
		
		}
		
		if( !empty( $exluded_terms ) ){
			
			$query_args['tax_query'] = !empty( $query_args['tax_query'] ) ? array_merge( $query_args['tax_query'], $exluded_terms ) : $exluded_terms;
		
		}
		
		//echo "<pre>"; print_r($query_args); echo "</pre>";
		
		$grp_wp_query = new WP_Query( $query_args );
		
		$view_type = self::grp_template_type( $config_settings[$post_type], $post_type );
		
		$html = self::grp_template_part( $view_type, $config_settings, $post_type );
		
		//restore query post data...
		$wp_query = $grp_store_query_post;
		
		return $html;
		
	}
	
	public static function grp_template_type( $config_settings, $post_type ) {
		
		$layout_type = $config_settings['layout']['layout_type'] ? 'default-'.$config_settings['layout']['layout_type'] : 'default-thumb';
		
		return apply_filters('grp_template_type', $layout_type, $config_settings, $post_type );
		
	}
	
	public static function grp_template_part( $view_type = 'default-thumb', $config_settings, $post_type ) {
		
		ob_start();
		
		if( locate_template( array( 'grp-related-posts/grp-template-'.$view_type.'.php' ) ) ){
			
			$template = locate_template( array( 'grp-related-posts/grp-template-'.$view_type.'.php' ) );
			
		}else{
			
			$template = GRP_PLUGIN_DIR . 'templates/grp-template-'.$view_type.'.php';
			
		}
		
		$template = apply_filters('grp_template_part', $template, $view_type, $config_settings, $post_type );
		
		include($template);
		
		return ob_get_clean();
		
	}
	
	public static function gem_events_template_script(){
	
		//wp_enqueue_script('jquery-gem-templates-js', GRP_PLUGIN_DIR_URL.'assets/js/jquery.gem.templates.js', array('jquery'), '', true);
	
	}
	
	public static function grp_frontend_style(){
	
		wp_enqueue_style( 'grp-style-front-end', GRP_PLUGIN_DIR_URL.'assets/css/grp-style-front-end.css', array(), GRP_PLUGIN_VER, false );
	
	}

}

?>