<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function grp_get_post_types(  $field = 'name'  ){
	
	$post_types = get_post_types( array(), 'objects' );
	
	$post_types = array_filter( $post_types, 'grp_post_types_filter' );
	
	if ( $field === 'objects' ) {
		return $post_types;
	}
	
	return wp_list_pluck( $post_types, $field );

}

function grp_post_types_filter( $post_type ){
	
	if ( $post_type->public ) {
		return true;
	}

}


function grp_get_taxonomies($key, $field, $operator) {
	
	$taxonomies = get_object_taxonomies( esc_attr( $key ), 'objects' );
	
	$taxonomies = array_filter( $taxonomies, 'grp_taxonomy_filter' );
	
	if ( $field ) {
		return wp_list_pluck( $taxonomies, $field );
	}
	
	return $taxonomies;
	
}


function grp_taxonomy_filter( $taxonomy ) {
	
	return ( $taxonomy->public && $taxonomy->show_ui );
	
}

function grp_get_taxonomy_object( $taxonomy ){
	
	return get_taxonomy( $taxonomy );
	
}

function grp_get_images_sizes( $selected_size = '' ){

	$image_sizes = array();
	
	$additional_image_sizes = wp_get_additional_image_sizes();
	$intermediate_image_sizes = get_intermediate_image_sizes();
	
	foreach( $intermediate_image_sizes as $size ){
		
		if( array_key_exists( $size, $additional_image_sizes ) ){
			
			$image_sizes[$size] = array(
				
				'width' => $additional_image_sizes[$size]['width'],
				'height' => $additional_image_sizes[$size]['height'],
				'crop' => $additional_image_sizes[$size]['crop']
			
			);
		
		}else{
		
			$image_sizes[$size] = array(
				
				'width' => get_option( $size . '_size_w' ),
				'height' => get_option( $size . '_size_w' ),
				'crop' => get_option( $size . '_size_w' )
			
			);
			
		}
	
	}
	
	if( !empty( $selected_size ) ){
		return isset( $image_sizes[$selected_size] ) ? $image_sizes[$selected_size] : '';
	}
	
	return $image_sizes;
	
}


function grp_strip_tags( $content = '' ){
	
	$excerpt = strip_shortcodes( $content );
	$excerpt = excerpt_remove_blocks( $excerpt );
	
	/** This filter is documented in wp-includes/post-template.php */
	$excerpt = apply_filters( 'the_content', $excerpt );
	$excerpt = str_replace( ']]>', ']]&gt;', $excerpt );
	
	return $excerpt = wp_strip_all_tags( (string) $excerpt );
	
}

?>