<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class GRP_Admin_Settings {

	public static function init() {
		
		add_action( 'admin_menu', array( __CLASS__, 'grp_settings_admin_menu' ) );
		
		add_action( 'grp_admin_setting_pages', array( __CLASS__, 'grp_admin_setting_pages'), 10, 2  );
		
		add_action('admin_enqueue_scripts', array( __CLASS__, 'grp_backend_scripts' ) );
		
		add_action('wp_ajax_grp_update_section_settings', array( __CLASS__, 'grp_update_section_settings' ) );
		
		add_action('wp_ajax_nopriv_grp_update_section_settings', array( __CLASS__, 'grp_update_section_settings' ) );
		
		add_action('wp_ajax_grp_update_global_settings', array( __CLASS__, 'grp_update_global_settings' ) );
		
		add_action('wp_ajax_nopriv_grp_update_global_settings', array( __CLASS__, 'grp_update_global_settings' ) );
		
		add_filter( 'plugin_action_links', array( __CLASS__, 'grp_action_link' ), 10, 2 );
		
		/* ------- NEED HELP SCRIPT ------- */
		add_action('admin_footer', array( __CLASS__, 'grp_need_help_popup' ));
		add_action('wp_ajax_grp_need_help_request_submit', array( __CLASS__, 'grp_need_help_request_submit' ) );
		add_action('wp_ajax_nopriv_grp_need_help_request_submit', array( __CLASS__, 'grp_need_help_request_submit' ) );
		
	}
	
	public static function grp_settings_admin_menu() {
		
		add_menu_page( __( 'Gou Related Post Settings', 'gou-manage-related-posts-similar-posts' ), __( 'Gou Related Posts', 'gou-manage-related-posts-similar-posts' ), 'manage_options', 'grp_settings', array( __CLASS__, 'grp_related_posts_settings' ) );
		
	}
	
	public static function grp_related_posts_settings($object) {
		
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
		 return;
		}
		
		include_once( GRP_PLUGIN_DIR . 'admin/grp-admin-setting-forms.php' );
		
	}
  
	public static function grp_backend_scripts(){
		
		global $pagenow;
		
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only check for admin page routing.
		if( $pagenow == 'admin.php' && ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'grp_settings' ) ){
			
			wp_enqueue_media();
		
			wp_enqueue_style( 'grp-style-backend', GRP_PLUGIN_DIR_URL.'admin/assets/css/style-backend.css', array(), GRP_PLUGIN_VER, false );
			
			wp_register_script('jquery.grp.backend.custom', GRP_PLUGIN_DIR_URL.'admin/assets/js/jquery.grp.backend.custom.js', array('jquery'), GRP_PLUGIN_VER, true);
			
			wp_enqueue_script( 'jquery.grp.backend.custom' );
			
			$translation_array = array(
				'grp_ajax_url' => admin_url( 'admin-ajax.php' )
			);
			
			wp_localize_script( 'jquery.grp.backend.custom', 'grp_localize_script', $translation_array );
			
			wp_enqueue_script( 'jquery.grp.backend.custom' );
			
			
		}
		
	}
	
	public static function grp_admin_setting_pages( $page, $section ){
		
		if( $section == '' ){
			
			include_once( GRP_PLUGIN_DIR . 'admin/grp-admin-general-settings.php' );
			
		}
		
		if( $section == 'grp_configuration' ){
		
			include_once( GRP_PLUGIN_DIR . 'admin/grp-admin-configuration-settings.php' );
			
		}
		
	}
	
	public static function grp_configuration_match_select_opts( $taxonomy ){
		
		if( $taxonomy == '' )
			return;
		
		$taxonomy_object = grp_get_taxonomy_object( $taxonomy );
		
		$options_html = array();
		
		if( !empty( $taxonomy_object ) ){
		
			$singular_name = $taxonomy_object->labels->singular_name;
			$name = $taxonomy_object->labels->name;
			
			$options_html['ignore_match'] = __( 'Ignore Match', 'gou-manage-related-posts-similar-posts' );
			$options_html['within_match'] = __( 'Within match', 'gou-manage-related-posts-similar-posts' );
            /* translators: %s: singular post type name */
			$options_html['match_one_cat'] = sprintf( __( 'Must be match at least one %s', 'gou-manage-related-posts-similar-posts' ), $singular_name );
		
		}
		
		return apply_filters('grp_configuration_match_select_opts', $options_html);
	
	}
	
	public static function grp_configuration_order_by_opts( $post_type = '' ){
		
		$options_html = array();
		
		$options_html['date_desc'] = __( 'Created Date (New to Old)', 'gou-manage-related-posts-similar-posts' );
		$options_html['date_asc'] = __( 'Created Date (Old to New)', 'gou-manage-related-posts-similar-posts' );
		$options_html['title_asc'] = __( 'Title (Ascending)', 'gou-manage-related-posts-similar-posts' );
		$options_html['title_desc'] = __( 'Title (Descending)', 'gou-manage-related-posts-similar-posts' );
		$options_html['rand_asc'] = __( 'Random Posts', 'gou-manage-related-posts-similar-posts' );
		$options_html['comment_count_asc'] = __( 'Number of Comments (Low to High)', 'gou-manage-related-posts-similar-posts' );
		$options_html['comment_count_desc'] = __( 'Number of Comments (High to Low)', 'gou-manage-related-posts-similar-posts' );
		
		return apply_filters('grp_configuration_order_by_opts', $options_html, $post_type);
		
	}
	
	public static function grp_update_section_settings(){
	
		global $wpdb;
		
        if (
            ! isset( $_POST['_wpnonce_grp_admin_configuration_settings'] ) ||
            ! wp_verify_nonce(
                sanitize_text_field( wp_unslash( $_POST['_wpnonce_grp_admin_configuration_settings'] ) ),
                'grp-admin-configuration-settings'
            )
        ) {
            wp_die( esc_html__( 'Action failed. Please refresh the page and retry.', 'gou-manage-related-posts-similar-posts' ) );
        }

		
		$submit_message = array();
		
		$grp_configuration_fields = isset( $_POST['grp_configuration_fields'] ) ? map_deep( wp_unslash( $_POST['grp_configuration_fields'] ), 'sanitize_text_field' ) : '';
		
		/*echo "<pre>"; print_r($grp_configuration_fields); echo "</pre>";*/
		
		$post_type = is_array( $grp_configuration_fields ) ? array_key_first( $grp_configuration_fields ) : '';
		
		if( !$post_type ){
			return;
		}
		
		$configuration_settings = get_option( 'grp_configuration_settings' );
		
		if( $configuration_settings == '' ){
			
			$configuration_settings = array();
			
		}
		
		if( is_array( $configuration_settings ) && !empty( $configuration_settings ) && array_key_exists( $post_type, $configuration_settings ) ){
			
			unset( $configuration_settings[$post_type] );
		
		}
		
		$configuration_settings[$post_type] = $grp_configuration_fields[$post_type];
		
		update_option( 'grp_configuration_settings', map_deep( wp_unslash( $configuration_settings ), 'sanitize_text_field' ) );
		
		//echo "<pre>"; print_r($_POST); echo "</pre>";
		
		$section_enable_text = __('Disabled', 'gou-manage-related-posts-similar-posts' );
		
		if( $grp_configuration_fields[$post_type]['is_enable'] == 'yes' ){
			
			$section_enable_text = __('Enabled', 'gou-manage-related-posts-similar-posts' );
			
		}
		
		$submit_message['code'] = 200;
		$submit_message['section_enable_text'] = $section_enable_text;
		
		echo json_encode($submit_message);
		
		exit;
		
	}
	
	public static function grp_update_global_settings(){
	
		global $wpdb;

        if (
            ! isset( $_POST['_wpnonce_grp_admin_general_settings'] ) ||
            ! wp_verify_nonce(
                sanitize_text_field( wp_unslash( $_POST['_wpnonce_grp_admin_general_settings'] ) ),
                'grp-admin-general-settings'
            )
        ) {
            wp_die( esc_html__( 'Action failed. Please refresh the page and retry.', 'gou-manage-related-posts-similar-posts' ) );
        }
		
		$submit_message = array();
		
        $grp_global_fields = isset( $_POST['grp_global_fields'] ) 
            ? array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['grp_global_fields'] ) ) 
            : array();

        update_option( 'grp_global_settings', $grp_global_fields );
		
		$submit_message['code'] = 200;
		
		echo json_encode($submit_message);
		
		exit;
		
	}
	
	public static function grp_action_link( $actions, $plugin_file ) {
		
		if ( $plugin_file == 'gou-manage-related-posts-similar-posts/gou-related-posts.php' ) {
			
			$settings = array( 'settings' => '<a href="' . admin_url( 'admin.php?page=grp_settings&section=grp_configuration' ) . '">' . __( 'Settings', 'gou-manage-related-posts-similar-posts' ) . '</a>' );

			$actions = array_merge( $settings, $actions );
		}
		
		return $actions;
	}
	
	public static function grp_need_help_popup(){
		
		global $pagenow;
		
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only check for admin page routing.
		if( $pagenow == 'admin.php' && ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'grp_settings' ) ){
			
			include_once( GRP_PLUGIN_DIR . 'admin/grp-need-help-popup.php' );
			
		}
	
	}
	
	public static function grp_need_help_request_submit(){
	
		global $wpdb;

        // 1️⃣ Verify nonce
        $nonce = isset( $_POST['_wpnonce_grp_need_help'] )
            ? sanitize_text_field( wp_unslash( $_POST['_wpnonce_grp_need_help'] ) )
            : '';

        if ( ! wp_verify_nonce( $nonce, 'grp-need-help-nonce' ) ) {
            wp_send_json_error(
                array( 'message' => esc_html__( 'Action failed. Please refresh the page and retry.', 'gou-manage-related-posts-similar-posts' ) )
            );
        }
		
		$submit_message = array();
		
		$full_name = isset( $_POST['grp_need_help_full_name'] ) ? sanitize_text_field( wp_unslash( $_POST['grp_need_help_full_name'] ) ) : '';
		$email = isset( $_POST['grp_need_help_email'] ) ? sanitize_text_field( wp_unslash( $_POST['grp_need_help_email'] ) ) : '';
		$message = isset( $_POST['grp_need_help_message'] ) ? sanitize_textarea_field( wp_unslash($_POST['grp_need_help_message']) ) : '';
		
		$to = 'aslamkhangouran@gmail.com';
		
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
		$headers .= 'From: '.get_bloginfo('name').' <'.$email .'>';
		
		$subject = sprintf( esc_attr('Need Help ( %s )', 'gou-manage-related-posts-similar-posts' ), GRP_PLUGIN_NAME );
		
		$message .= "\r\n\r\n";
		$message .= sprintf( esc_attr('Name : %s', 'gou-manage-related-posts-similar-posts' ), $full_name )."\r\n";
		$message .= sprintf( esc_attr('Email : %s', 'gou-manage-related-posts-similar-posts' ), $email )."\r\n";
		$message .= sprintf( esc_attr('Website : %s', 'gou-manage-related-posts-similar-posts' ), site_url() );
		
		wp_mail($to, wp_specialchars_decode($subject),  wp_specialchars_decode(nl2br($message)), $headers);
		
		$submit_message['code'] = 200;
		
		echo json_encode($submit_message);
		
		exit;
		
	}
	
}




?>