<?php
/**
 * Plugin Name: Gou Manage Related Posts | Similar Posts
 * Plugin URI: https://areedit.com/
 * Description: Extension for WordPress to manage Related Posts. Functionality to set layout (list view or grid view) of related posts listing for separate post types.
 * Author: Aslam Khan Gouran
 * Author URI: https://areedit.com/
 * Text Domain: gou-manage-related-posts-similar-posts
 * Version: 3.7.9.8
 * WC requires at least: 4.5
 * Tested up to: 6.9
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 */
 
/**
 * Required functions
 */

final class GRP_Related_Posts {
	
	private static $instance = null;
	
	public static function instance() {
		
		self::$instance = new GRP_Related_Posts;
		
		self::$instance->setup_constants();
		
		self::$instance->includes();
		
		self::$instance->enqueue_scripts();
		
	}
	
	private function setup_constants() {
		
		$plugin_path = plugin_dir_path( __FILE__ );
		$plugin_dir_url = plugin_dir_url( __FILE__ );
		
		if( !function_exists('get_plugin_data') ){
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		$plugin_data = get_plugin_data( __FILE__ );
		$plugin_name = $plugin_data['Name'];
		
		define( 'GRP_PLUGIN_DIR', $plugin_path );
		define( 'GRP_PLUGIN_DIR_URL', $plugin_dir_url );
		define( 'GRP_PLUGIN_NAME', $plugin_name );
		define( 'GRP_PLUGIN_VER', '3.7.9.8' );
		
	}
	
	 private function includes() {
	 	
		global $pagenow;
		
		include_once( GRP_PLUGIN_DIR . 'includes/grp-admin-settings.php' ); // plugin settings...
		
		GRP_Admin_Settings::init();
		
		include_once( GRP_PLUGIN_DIR . 'includes/grp-post-filters.php' ); // plugin settings...
		
		GRP_Post_Filters::init();
		
		include_once( GRP_PLUGIN_DIR . 'includes/grp-custom-templates.php' ); // plugin settings...
		
		GRP_Custom_Templates::init();
		
		/*if( 'admin.php' === $pagenow && isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'grp_settings' ){
			
			GRP_Meta_Boxes::init();
			
		}*/
		
		
		include_once( GRP_PLUGIN_DIR . 'includes/grp-custom-functions.php' ); // Custom Functions...
	 
	 }
	 
	 private function enqueue_scripts(){
	 	
		//add_action( 'admin_enqueue_scripts', array( $this, 'event_form_fields_scripts' ), 10 );
		//add_action( 'admin_enqueue_scripts', array( $this, 'event_form_fields_style' ), 10 );
	 
	 }
	 
	 
}


function GrpRelatedPosts() {
    return GRP_Related_Posts::instance();
}

// Global for backwards compatibility.
$GLOBALS['grp_related_posts'] = GrpRelatedPosts();



